; JFW 3.31 script file for Microsoft Excel
; Copyright 1998-1999 by Henter-Joyce, Inc.
; Build xl3311337 30 August 1999 J K Stephen (formerly Dunn): ; Excel 95 and 97/2000 scripts are now in different sets.
; This file contains the support for Excel 97/2000 only.
; See Excel95.jss for Excel 95 and earlier support. 

include "excelall.jsh" ; constants and globals common to all versions of Excel
include "excel.jsh" ; constants and globals specific to Excel 97 and 2000 
include "excelall.jsm" ; Common msgs for all versions of Excel
include "excel.jsm" ; messages specific to Excel 97 and 2000
Include "hjglobal.jsh"
include "hjconst.jsh"
use "magExcel.jsb"

Function AutoStartEvent ()
; If Excel version prior to 8 then switch to the Excel 95 script set.
 if (GetProgramVersion (GetAppFilePath ()) < 8) then
	switchToScriptFile (Excel95, defaultScripts) 
	return ; shouldn't need this but here for clarity.
endIf
; We are running Excel 97 or 2000
SayInteger (MagGetState ())
if (MagGetState () > 0) then
	ScheduleFunction ("CheckForSelectionChange", 1)
EndIf
InitializeOExcel ()
if (ExcelFirstTime == 0) then
	let ExcelFirstTime = 1
	if GetVerbosity() == beginner then
		Say (msg50, OT_HELP) ;"Use Insert plus the letter H for help in various dialog boxes"
	EndIf ; verbosity beginner
endif ; first time
EndFunction

Function AutoFinishEvent ()
var
	object null
let oExcel = null;
EndFunction

Void Function InitializeOExcel ()
if !oExcel then
	let oExcel = MSOGetMenuBarObject ();
	let oExcel = oExcel.Application
	if !oExcel then
 		let oExcel = GetObject (msg757); "Excel.Application"
	EndIf
EndIf
EndFunction



Script ScriptFileName ()
ScriptAndAppNames(msg900)
EndScript

Script SayPriorLine ()
var
	int TheTypeCode
priorLine()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor () then
	SayLine ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if (GetWindowClass (getFocus() ) == wc7) then
	if (MenusActive () == False) then
		ReadSelectedCells ()
		return
	endif; menus not active
endif; in main spread sheet
if CaretVisible () then
	SayLine ()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
endif
EndScript

Script SayNextLine ()
var
	int TheTypeCode
NextLine()

if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor () then
	SayLine ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if (GetWindowClass (getFocus() ) == wc7) then
	if (MenusActive () == False) then
		ReadSelectedCells ()
		return
	endif; menus not active
endif; in main spread sheet
if CaretVisible () then
	SayLine ()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
endif
EndScript

Script SayPriorCharacter ()
var
	int TheTypeCode
PriorCharacter()

if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if (GetWindowClass (GetFocus ()) == wc7) then
	if (MenusActive () == False) then
		ReadSelectedCells ()
		return
	endif ; menus not active
endif ; in main spread sheet
if CaretVisible() then
	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say (msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say (msg4, OT_MESSAGE) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say (msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

Script SayNextCharacter ()
var
	int TheTypeCode
NextCharacter()

if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if (GetWindowClass (GetFocus ()) == wc7) then
	if (MenusActive () == False) then
		ReadSelectedCells ()
		return
	endif ; menus not active
endif ; in main spread sheet
if CaretVisible() then
	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say (msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say (msg4, OT_MESSAGE) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say (msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

Script SayCharacter ()
if IsPCCursor () then
	if (GetWindowClass (GetFocus ()) == wc7) then
		if (GlobalMenuMode == MENU_INACTIVE) then
			ReadSelectedCells ()
			return
		endif ; menus not active
	endif ; in main spread sheet
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord() ; says the current setting
		return
	endif
EndIf
if (IsSameScript ()) then
	SayCharacterPhonetic ()
	AddHook (HK_SCRIPT, "PhoneticSpellHook")
else
	SayCharacter()
EndIf
EndScript

Script JawsHome ()
JawsHome()
Pause()
Say (msg27, OT_MESSAGE) ;"home"
if IsPCCursor () then
	if (GetWindowClass (GetFocus ()) == wc7) then
		if (GlobalMenuMode == MENU_INACTIVE) then
			ReadSelectedCells ()
		endif ; menus not active
	endif ; in main spread sheet
EndIf
EndScript

Script JAWSEnd ()
;toggles you in and out of "end" mode
if IsJAWSCursor () then
	Say (msg28, OT_MESSAGE) ;"End"
EndIf
JAWSEnd ()
if getWindowclass(getFocus()) !=WC7 then
; not relevant
	return
endIf
if IsPCCursor () then
	SaveCursor ()
	InvisibleCursor ()
	if FindString(ExcelStatusHandle, msg28,s_bottom,s_restricted) then ;"End"
		If(GetVerbosity() == beginner) Then
			Say (msg29, OT_MESSAGE) ;"press any arrow key to move to end of data in current row or column"
		else
			Say (msg30, OT_MESSAGE) ;"press any arrow key"
		EndIf
	else
		Say (msg31, OT_MESSAGE) ;"End is off"
	EndIf
EndIf
EndScript

Script JawsPageUp ()
Say (msg23, OT_MESSAGE) ;"PageUp"
JAWSPageUp ()
Pause ()
if IsPCCursor()then
	PerFormScript SayCharacter()
EndIf
EndScript

Script JawsPageDown ()
Say (msg24, OT_MESSAGE) ;"PageDown"
JAWSPageDown ()
Pause ()
if IsPCCursor()then
	PerFormScript SayCharacter ()
EndIf
EndScript

Script DataRegionDown ()
	{Control + Down Arrow}
if GetWindowClass (GetFocus()) == wc7 then
	if GetVerbosity()==beginner then
		Say (msg48, OT_MESSAGE) ;"edge of current data region"
	endIf
	readSelectedCells()
endIf
EndScript

Script  DataRegionLeft()
;moves to edge of data region
{Control+Left Arrow}
if GetWindowClass (GetFocus()) == wc7 then
	if GetVerbosity()==beginner then
		Say (msg48, OT_MESSAGE) ;"edge of current data region"
	endIf
	readSelectedCells()
endIf
EndScript

Script  DataRegionRight()
;moves to edge of data region
{Control+Right Arrow}
if GetWindowClass (GetFocus()) == wc7 then
	if GetVerbosity()==beginner then
		Say (msg48, OT_MESSAGE) ;"edge of current data region"
	endIf
	readSelectedCells()
endIf
EndScript

Script  DataRegionUp()
;moves to edge of data region
{Control+Up Arrow}
if GetWindowClass (GetFocus()) == wc7 then
	if GetVerbosity()==beginner then
		Say (msg48, OT_MESSAGE) ;"edge of current data region"
	endIf
	readSelectedCells()
endIf
EndScript

Script screenRight ()
;moves one screen to right
{Alt+PageDown}
if GetWindowClass(GetFocus())==wc7 then
	If(GetVerbosity() == beginner) Then
		Say (msg26, OT_MESSAGE) ;"Moved right one screen"
	readSelectedCells()
	endIf
endIf
EndScript

Script screenLeft ()
;moves one screen to Left
{Alt+PageUp}
if GetWindowClass(GetFocus())==wc7 then
	If(GetVerbosity() == beginner) Then
		Say (msg25, OT_MESSAGE) ;"Moved left one screen"
	readSelectedCells()
	endIf
endIf
EndScript

Script MoveToFirstCell ()
{Control + Home}
Say (msg18, OT_MESSAGE) ;"First cell"
ReadSelectedCells ()
EndScript

Script MoveToLastCell ()
{Control + End}
Say (msg19, OT_MESSAGE) ;"Last Cell"
pause ()
ReadSelectedCells ()
EndScript

string Function getColTitleOfCell (int currentCol, int currentRow)
var
int index,
string title,
string tmp
if globalTitleReading !=readColumnTitles && globalTitleReading!=readBothTitles then
; do nothing
	return ""
endIf
if globalTitleRowStart==0 then
	let globalTitleRowStart=1
	let globalTitleRowEnd=1
endIf
if globalTitleRowEnd < globalTitleRowStart then
	let globalTitleRowEnd=globalTitleRowStart
endIf
; only want to speak col title if not in title column itself
; or not above column titles
if currentRow <= globalTitleRowEnd then
	let globalRowOrColTitle= ""
else
	let index=globalTitleRowStart
let tmp=""
	while index <=globalTitleRowEnd
	let title= oExcel.activeSheet.columns(currentCol).cells(index).text
		let tmp=tmp+title+msg773
		let index=index+1
	endWhile
	let globalRowOrColTitle=tmp
endIf
return globalRowOrColTitle
EndFunction

string Function getColTitle ()
var
int currentRow,
int currentCol,
int index,
string title,
string tmp
if globalTitleReading !=readColumnTitles && globalTitleReading!=readBothTitles then
; do nothing
	return ""
endIf
if globalTitleRowStart==0 then
	let globalTitleRowStart=1
	let globalTitleRowEnd=1
endIf
if globalTitleRowEnd < globalTitleRowStart then
	let globalTitleRowEnd=globalTitleRowStart
endIf
let currentRow=oExcel.activeCell.row
let currentCol=oExcel.activeCell.column
; only want to speak col title if not in title column itself
; or not above column titles
if currentRow <= globalTitleRowEnd then
	let globalRowOrColTitle= ""
else
	let index=globalTitleRowStart
let tmp=""
	while index <=globalTitleRowEnd
	let title= oExcel.activeSheet.columns(currentCol).cells(index).text
		let tmp=tmp+title+msg773
		let index=index+1
	endWhile
	let globalRowOrColTitle=tmp
endIf
return globalRowOrColTitle
EndFunction

string Function getRowTitleOfCell (int currentCol, int CurrentRow)
var
string title,
string tmp,
int index
if globalTitleReading !=readRowTitles && globalTitleReading!=readBothTitles then
; do nothing
	return ""
endIf
if globalTitleColStart==0 then
	let globalTitleColStart=1
	let globalTitleColEnd=1
endIf
if globalTitleColEnd < globalTitleColStart then
	let globalTitleColEnd=globalTitleColStart
endIf
if currentCol <= globalTitleColEnd then
	let globalRowOrColTitle=""
else
	let index=globalTitleColStart
let tmp=""
	while index <=globalTitleColEnd
		let title=oExcel.activeSheet.rows(currentRow).cells(index).text
		let tmp=tmp+title+msg773
		let index=index+1
	endWhile
	let globalRowOrColTitle=tmp
endIf
return globalRowOrColTitle
EndFunction

string Function getRowTitle ()
var
int currentRow,
int currentCol,
string title,
string tmp,
int index
if globalTitleReading !=readRowTitles && globalTitleReading!=readBothTitles then
; do nothing
	return ""
endIf
if globalTitleColStart==0 then
	let globalTitleColStart=1
	let globalTitleColEnd=1
endIf
if globalTitleColEnd < globalTitleColStart then
	let globalTitleColEnd=globalTitleColStart
endIf
let currentRow=oExcel.activeCell.row
let currentCol=oExcel.activeCell.column
if currentCol <= globalTitleColEnd then
	let globalRowOrColTitle=""
else
	let index=globalTitleColStart
let tmp=""
	while index <=globalTitleColEnd
		let title=oExcel.activeSheet.rows(currentRow).cells(index).text
		let tmp=tmp+title+msg773
		let index=index+1
	endWhile
	let globalRowOrColTitle=tmp
endIf
return globalRowOrColTitle
EndFunction

Script SayActiveCellCoordinates ()
SayCellCoordinates (oExcel.activeCell)
if globalTitleReading then
	Say (getColTitle(), OT_STRING)
	say (getRowTitle(), OT_STRING)
endIf
EndScript

Script SaySelectedText ()
var
	handle WinHandle
let WinHandle = GetFocus ()
if (GetWindowClass (WinHandle) == wc7) then
	if (GlobalMenuMode == MENU_INACTIVE) then
		if (GetVerbosity() <= intermediate) Then
 			Say (msg33, OT_MESSAGE); "selected range"
		endif
		ReadSelectedCells ()
		return
	EndIf
EndIf
PerformScript SaySelectedText ()
EndScript

OBJECT Function GetCurrentCell ()
    InitializeOExcel ()
return oExcel.Selection.Cells(1)
EndFunction

Script ColumnFirstCellFromTop ()
var
	object theCell,
	object firstCellInColumn,
	string strBuffer
let theCell = GetCurrentCell ()
let firstCellInColumn = oExcel.Cells (1, theCell.Column)
let strBuffer = firstCellInColumn.Text
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
else
	Say (msg711, OT_BUFFER) ; "Blank"
EndIf
EndScript

Script ColumnSecondCellFromTop ()
var
	object theCell,
	object secondCellInColumn,
	string strBuffer
let theCell = GetCurrentCell ()
let secondCellInColumn = oExcel.Cells (2, theCell.Column)
let strBuffer = secondCellInColumn.Text
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
else
	Say (msg711, OT_BUFFER); "Blank"
EndIf
EndScript

Script ColumnThirdCellFromTop ()
var
	object theCell,
	object thirdCellInColumn,
	string strBuffer
let theCell = GetCurrentCell ()
let thirdCellInColumn = oExcel.Cells (3, theCell.Column)
let strBuffer = thirdCellInColumn.Text
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
else
	Say (msg711, OT_BUFFER) ; "Blank"
EndIf
EndScript

Script ColumnFourthCellFromTop ()
var
	object theCell,
	object fourthCellInColumn,
	string strBuffer
let theCell = GetCurrentCell ()
let fourthCellInColumn = oExcel.Cells (4, theCell.Column)
let strBuffer = fourthCellInColumn.Text
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
else
	Say (msg711, OT_BUFFER) ; "Blank"
EndIf
EndScript

Script RowFirstCellFromLeft ()
var
	object theCell,
	object firstCellInRow,
	string strBuffer
let theCell = GetCurrentCell ()
let firstCellInRow = oExcel.Cells (theCell.Row, 1)
let strBuffer = firstCellInRow.Text
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
else
	Say (msg711, OT_BUFFER) ; "Blank"
EndIf
EndScript

Script RowSecondCellFromLeft ()
var
	object theCell,
	object secondCellInRow,
	string strBuffer
let theCell = GetCurrentCell ()
let secondCellInRow = oExcel.Cells (theCell.Row, 2)
let strBuffer = secondCellInRow.Text
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
else
	Say (msg711, OT_BUFFER) ; "Blank"
EndIf
EndScript

Script RowThirdCellFromLeft ()
var
	object theCell,
	object thirdCellInRow,
	string strBuffer
let theCell = GetCurrentCell ()
let thirdCellInRow = oExcel.Cells (theCell.Row, 3)
let strBuffer = thirdCellInRow.Text
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
else
	Say (msg711, OT_BUFFER)
EndIf
EndScript

Script RowFourthCellFromLeft ()
var
	object theCell,
	object fourthCellInRow,
	string strBuffer
let theCell = GetCurrentCell ()
let fourthCellInRow = oExcel.Cells (theCell.Row, 4)
let strBuffer = fourthCellInRow.Text
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
else
	Say (msg711, OT_BUFFER) ; "Blank"
EndIf
EndScript

Script ScreenSensitiveHelp ()
var
	string TheClass

if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf

let TheClass = GetWindowClass (GetCurrentWindow ())
if (oExcel.selection.cells.count==0) && (oExcel.activeChart.chartType != 0) && not menusActive() then
	if getVerbosity()==beginner then
		say(msg895,ot_help) ; this is a chart.
	endIf
	readChart(OExcel.activeChart)
	if getVerbosity()==beginner then
		say(msg896,ot_help) ; press escape to return to the spreadsheet.
	endIf
	return
endIf
if (TheClass == wc7) then
	Say (msg119, OT_HELP) ;"This is the spread sheet area"
	if GetVerbosity()==beginner then
		say(msg894, ot_help) ; the worksheet name is
	endIf
	Say (oExcel.activeSheet.name, OT_HELP)
	PerformScript sayVisibleRangeCoordinates()
	if oExcel.activeSheet.shapes.count > 0 then
		Say (msg416+intToString(oExcel.activeSheet.shapes.count)+msg417, OT_HELP) ; Active worksheet contains x shapes.
		say (msg420+msg399+getScriptKeyName("SelectWorksheetObjects")+msg760, OT_HELP) ; to select a shape.
	EndIf
	if oExcel.activeSheet.hyperlinks.count > 0 then
		Say (msg416+intToString(oExcel.activeSheet.hyperlinks.count)+msg427, OT_HELP)
		say (msg426+msg399+getScriptKeyName("selectHyperlink")+msg760, OT_HELP) ; to select a hyperlink
	endIf
	performScript reportGridlineStatus()
performScript DescribeCellBorder()
	 return
EndIf ; Main Grid
if (GlobalMenuMode == MENUBAR_ACTIVE) then
	ScreenSensitiveHelpForKnownClasses (WT_COMMANDBAR)
	return
endif
if (GlobalMenuMode == MENU_ACTIVE) then
	ScreenSensitiveHelpForKnownClasses (wt_menu)
	return
EndIf
PerformScript ScreenSensitiveHelp ()
EndScript

Script HotKeyHelp ()
;wc5="bosa_sdm_XL"
if (GetWindowClass (GetRealWindow (GetCurrentWindow ())) == wc5)
;wc3="edtbx"
|| (GetWindowClass (GetRealWindow (GetCurrentWindow ())) == wc3 ) then
;wn56="Spelling"
	if (GetWindowName (GetRealWindow (GetFocus())) == wn56)
;wn56="Spelling"
	|| (GetWindowName (GetParent (GetFocus())) == wn56) then
		Say (msg57, OT_HELP) ;"type in a replacement word and then enter"
		Say (msg58, OT_HELP) ;" or use one of the following options"
		Say (msg59, OT_HELP) ;"To hear the misspelled word and suggestion use Insert plus F7"
		Say (msg61, OT_HELP) ;"Use the tab key or the following windows hot keys"
		Say (msg62, OT_HELP) ;"To move to suggestions list box use Alt N"
		Say (msg63, OT_HELP) ;"To return to Change to: edit box use Alt T"
		Say (msg64, OT_HELP) ;"To Choose the ignore option use Alt I"
		Say (msg65, OT_HELP) ;"To choose the ignore all option use Alt G"
		Say (msg66, OT_HELP) ;"To except the reccommended change use Alt C"
		Say (msg67, OT_HELP) ;"To except the reccommended change for all occurrances use Alt L"
		Say (msg68, OT_HELP) ;"To select the always suggest check box use Alt y"
		Say (msg69, OT_HELP) ;"To select the ignore uppercase check box use alt e"
		Say (msg70, OT_HELP) ;"To Add word to dictionary use Alt A"
		Say (msg71, OT_HELP) ;"To select a specific dictionary to add words use Alt W"
		Say (msg72, OT_HELP) ;"To undo last change use Alt U"
		Say (msg72b, OT_HELP);"To use auto correct use alt r"
		Say (msg73, OT_HELP) ;"For Help with spell checker use Alt H or escape to cancel"
		Return
	EndIf
	Say (msg706 + GetWindowName(GetRealWindow(GetFocus())) + msg707, OT_HELP)
	Say (msg708, OT_HELP) ; "Use tab and shift + tab to move between the controls"
	Say (msg709, OT_HELP) ; "Use insert + f1 for screen sensitive help"
	;take care of some known problematic dialogs.  If it is not problematic, then
	;use the HotKeyHelpDefaultLoop
	if (!ExcelHotKeyHelp()) then
		HotKeyHelpDefaultLoop () 
	endIf
	return
Else
	if (oExcel.selection.cells.count==0) && (oExcel.activeChart.chartType != 0) && not menusActive() then
		say(OExcel.activeChart.chartTitle.caption,ot_help)
		say(msg896, ot_help) ; press esc to return to the spreadsheet
		return
	endIf
	;msg760 = ". "
	Say (msg78+msg399+getScriptKeyName("WindowKeysHelp")+msg760, OT_HELP) ;"Use insert + w for a  list of some excel standard keyboard commands"
	Say (msg79 + GetScriptKeyName ("SayActiveCellCoordinates") + msg760, OT_HELP) ; "To hear the coordinates of current cell, use "
	Say (msg80, OT_HELP) ;"If you hear has formula when you move to a cell, use
	Say (GetScriptKeyName ("SayFormula")+msg81, OT_HELP) ;"To review the formula, use Control plus F2"
	Say (msg82, OT_HELP) ;"to review selected cells, use shift plus insert down arrow"
	say (msg408+msg399+getScriptKeyName("sayVisibleRangeCoordinates")+msg760, OT_HELP) ; " to announce the coordinates of the range of cells visible in the active window."
	say (msg407+msg399+getScriptKeyName("reportGridlineStatus")+msg760, OT_HELP) ; to speak the status of gridlines in the active window.
	Say (msg402+msg399+GetScriptKeyName("DescribeCellBorder")+msg760, OT_HELP) ; To hear description of border use Alt+shift+b.
	Say (msg83, OT_HELP) ;"To hear the contents of the top 4 cells in the column"
	Say (msg84, OT_HELP) ;"Use the alt key with 1 through 4 on the number row"
	Say (msg85, OT_HELP) ;"To hear the contents of the 4 cells from the left margin"
	Say (msg86, OT_HELP) ;"Use the alt+control key with 1 through 4 on the number row"
	say (msg405+msg399+getScriptKeyName("listRow")+msg406+getScriptKeyName("listColumn")+msg760, OT_HELP) ; use insert+r or c to list cells with data in current row or column respectively.
	say (msg409a+msg399+getScriptKeyName("ListVisibleCellsWithData")+msg760, OT_HELP) ; to list cells with data visible in active window
	say (msg410+msg399+getScriptKeyName("ListCellsAtPageBreaks")+msg760, OT_HELP) ; " to list cells at horiz and vert pg brks."
	say (msg409+msg399+getScriptKeyName("listCellsWithComments")+msg760, OT_HELP) ; to list cells with comments visible in active window
	say (msg403+msg399+getScriptKeyName("ReadCellComment")+msg760, OT_HELP) ; use alt+shift+' to hear comment (if visible)
	say (msg426+msg399+getScriptKeyName("selectHyperlink")+msg760, OT_HELP) ; to select a hyperlink
	Say (msg353+msg399+GetScriptKeyName("readCellHyperlink")+msg760, OT_HELP) ; to read the cell hyperlink address
	say (msg420+msg399+getScriptKeyName("SelectWorksheetObjects")+msg760, OT_HELP) ; to select a shape.
	say(msg903,ot_help) ; ctrl pgup/down prior/next sheet
	say(msg902+msg399+getScriptKeyName("moveToWorksheet")+msg760,ot_help) ; select a worksheet
say (msg404+msg399+getScriptKeyName("AutoFilter")+msg760, OT_HELP) ; use control+shift+a to get to the custom autofilter dlg.
	say(msg907+getScriptKeyName("adjustJawsVerbosity")+msg908,ot_help)	
	say (msg686+msg399+getScriptKeyName("toggleTitleReadingVerbosity")+msg760, OT_HELP) ; use xx to toggle title reading on and off
	say (msg687+msg399+getScriptKeyName("setRowTitlesToColumnRange")+msg760, OT_HELP) ; to set row titles to current col
	say (msg688+msg399+getScriptKeyName("setColTitlesToRowRange")+msg760, OT_HELP) ; to set col titles to current row
	say (msg701+msg399+getScriptKeyName("ReadRowTotal")+msg760, OT_HELP) ; to read row total
	say (msg702+msg399+getScriptKeyName("readColumnTotal")+msg760, OT_HELP) ; to read column total
	say (msg699+msg399+getScriptKeyName("setTotalRowToCurrent")+msg760, OT_HELP) ; to define the column for row totals
	say (msg700+msg399+getScriptKeyName("setTotalColumnToCurrent")+msg760, OT_HELP) ; to define the row for column totals
	say (msg704+msg399+getScriptKeyName("readMonitorCell")+msg760, OT_HELP) ; to read the monitor cell
	say (msg703+msg399+getScriptKeyName("setMonitorCellToCurrent")+msg760, OT_HELP) ; to set the monitor cell to current
	say (msg705+msg399+getScriptKeyName("clearAllDefinitions")+msg760, OT_HELP) ; to clear all definitions
EndIf
EndScript

String Function GetFormula ()
return oExcel.ActiveCell.formula()
EndFunction

Script SayFormula ()
if isSameScript() then
	messageBox(getFormula())
else
	say (getFormula(), OT_TEXT)
endIf
EndScript

Script SayBottomLineOfWindow ()
var
	HANDLE hWnd
let hWnd = GetAppMainWindow(GetFocus())
let hWnd = GetFirstChild(hWnd)
while (hWnd)
	if (GetWindowClass(hWnd) == WC4) then
		SayWindow(hWnd,READ_EVERYTHING)
		return
	endIf
	let hWnd = GetNextWindow(hWnd)
endWhile
EndScript

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
string TheClass
let TheClass = GetWindowClass(hwnd)
if ((GetScreenEcho() > 1)
;wn92="#32771"
|| (TheClass == wn92 )) then
Say (buffer, OT_BUFFER)
return
EndIf
; status line
if TheClass == wc4 then
	Let ExcelStatusHandle = hwnd
;wn93="Edit"
   if (StringContains (buffer, wn93)) then
Say (buffer, OT_BUFFER) ; say edit
return
endif
return ; done with status line
endif ; excel4, status line

; spell checker
if (GlobalCurrentControl == 17) then
;wn56="Spelling"
if (GlobalRealWindowName == wn56) then
;wn97="Not in Dictionary"
if ((StringContains (buffer, wn97))
;wn98="Capitalization:"
|| (StringContains (buffer, wn98))
;wn99="Repeated Word:"
|| (StringContains (buffer, wn99))) then
delay (2)
PerformScript SpellCheck()
EndIf
EndIf
EndIf
EndFunction

String Function GetStaticText ()
var
handle hwnd,
string Text
SaveCursor()
InvisibleCursor()
let Text = ""
let hwnd = GetFocus()
;wc11 = "MSOUNISTAT"
while (hwnd && GetWindowClass(hwnd) != wc11)
let hwnd = GetNextWindow (hwnd)
endWhile

if (hwnd) then
	MoveToWindow(hwnd)
	let Text = GetChunk()
endif
return Text
EndFunction

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
HANDLE RealWindow,
string RealWindowName,
HANDLE AppWindow

let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
let GlobalFocusWindow = FocusWindow ; used by sdm routine

;wc10="_sdm_"
 if (StringContains (GetWindowClass (RealWindow), wc10)) then
; we are in an SDM dialog
let GlobalRealWindow = RealWindow
let GlobalRealWindowName = RealWindowName
SaySDMFocusedWindow()
Else ; not sdm
;start of regular non-sdm logic
if (GlobalPrevApp != AppWindow
&& AppWindow != FocusWindow) then
; we've switched to a different app main window,
; and it does not have the focus, so announce it
SayWindowTypeAndText(AppWindow)
endif

If ((GlobalPrevRealName != RealWindowName) ; name has changed
|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
If ((RealWindow != AppWindow)
&& (RealWindow != FocusWindow)) then
SayWindowTypeAndText(RealWindow)
endif
EndIf
; now say the window with focus
if (GetWindowClass (FocusWindow) == wc7 ) then
	if (GetWindowClass (GlobalPrevFocus) == "EXCEL6") then
; do nothing, just edited a cell
		else
			SayFocusedWindow()
		EndIf
	else
		SayFocusedWindow()
	EndIf
EndIf ;end else sdm
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Function SaySDMFocusedWindow ()
; called by focus changed, to handle sdm dialogs
;Say (msg748, OT_DEBUG) ; "entering sdm"
let GlobalCurrentControl = SdmGetFocus (GlobalFocusWindow)
;wn56="Spelling"
if ((GlobalRealWindowName == wn56)
&& (GlobalCurrentControl == 17)) then
; highlighted text event says the mispelled word
return
endif ; spell dialog box on "word not found"
; If we've just entered a new real window say it
If (GlobalPrevReal != GlobalRealWindow)
|| GlobalRealWindowName != GlobalPrevRealName then
; the handles could be the same, check names?
SayWindowTypeAndText (GlobalRealWindow) ; dialog box name
SdmSayStaticText (GlobalRealWindow) ;dialog box text
endif ; new real window handle or name
; now say the current control
SdmSayWindowTypeAndText (GlobalFocusWindow, GlobalCurrentControl)
EndFunction

void function SayHighlightedText (handle hwnd, string buffer)
if(GetScreenEcho() > 0) Then
	;wn56="Spelling"
	if ((GlobalRealWindowName == wn56)
		&& (GlobalCurrentControl == 17)) then
		return
	endif ; spell dialog box on "word not found"
	Say (buffer, OT_BUFFER) ; say the highlighted text
EndIf
EndFunction

Script  SpellCheck()
;wn56="Spelling"
If ((GetWindowName (GetParent (GetFocus ())) == wn56)
;wn56="Spelling"
|| (GetWindowName (GetRealWindow (GetFocus ())) == wn56)) Then
RouteInvisibleToPc()
InvisibleCursor()
JawsPageUp()
NextLine()
JawsHome()
;wn103=":"
if StringContains (GetWord (), wn103) then
else
NextWord ()
endif ; string contains :
;wn103=":"
if StringContains (GetWord (), wn103) then
else
NextWord ()
endif ; string contains :
NextWord () ; move onto the word
If (GetVerbosity () > beginner) then
SayWord ()
Else
SayLine ()
EndIf
SpellWord() ;spell it either way
; now see if there are any suggestions
;fs104="(No Suggestions)"
if (FindString (GetFocus (), fs104, s_top, s_unrestricted)) then
Say (msg105, OT_MESSAGE) ;"no suggestions"
else ; there are suggestions, read the first one
NextLine()
JAWSHome ()
;wn103=":"
if StringContains (GetWord (), wn103) then
else
NextWord ()
endif ; string contains :
;wn103=":"
if StringContains (GetWord (), wn103) then
else
NextWord ()
endif ; string contains :
NextWord () ; move onto the word
If (GetVerbosity () > beginner) then
SayWord ()
Else
SayLine()
EndIf ; verbosity beginner
SpellWord() ;spell it either way
endif ; finst string "no suggestions"
PcCursor()
Else
Say (msg106, OT_MESSAGE) ;"Not in spell checker"
EndIf
EndScript

Script  PriorSheet()
;switches to the prior sheet and reads the number
{control+pageup}
delay (1)
SaySheetName()
EndScript

Script  NextSheet()
;switches to the next sheet and reads the number
{control+pagedown}
delay (1)
SaySheetName()
EndScript

Void Function SaySheetName ()
say(oExcel.activeSheet.name, ot_string)
EndFunction

Function CursorChangedEvent (string CursorType)
;CURSOR CHANGED EVENT Function
Let GlobalCursorType = CursorType
If (IsJAWSCursor ()) then
	If (CursorType == CT_UNKNOWN) then
		Say (msg122, OT_CURSOR) ;"Cross hair cursor"
		Return
	EndIf
	PerformScript SayCursorType ()
EndIf
EndFunction

Script AutoSum ()
;Used to autosum
{Alt+=}
If(GetVerbosity() == beginner) Then
Say (msg128, OT_MESSAGE) ;"Type in the range to Sum using colon to separate or"
Say (msg129, OT_MESSAGE) ;"Press enter to accept default range"
EndIf
If(GetVerbosity() == intermediate) Then
Say (msg130, OT_MESSAGE) ;"Type new range or Enter to accept"
EndIf
EndScript

Script BoldText ()
{control+b}
ReportFont (btnBold)
EndScript

Script ItalicText ()
{control+i}
ReportFont (btnItalic)
EndScript

Script UnderlineText ()
{control+u}
ReportFont (btnUnderline)
EndScript

Function ReportFont (string strButton)
var
	int state
let state = oExcel.commandbars(CBFormatting).controls(strButton).state()
if (state == -1) then
	Say (strButton+msg345, OT_STATUS)
else
	Say (strButton+msg346, OT_STATUS)
endif
EndFunction

Script SayFont ()
; Identify Font
var
	string strBuffer,
	object controls
if not (IsPCCursor ()) then
	PerformScript SayFont ()
	return ; all done, jaws or invisible cursor is on
EndIf ;is not pc cursor
if (GetWindowClass (GetCurrentWindow ()) != wc7) then
	PerformScript SayFont ()
	return
EndIf
let controls = oExcel.commandbars(CBFormatting).controls()
if controls(btnBold).state then
	Say (msg318, OT_STATUS) ;"bolded"
EndIf
if controls(btnItalic).state then
	Say (msg320, OT_STATUS) ;"italicized"
EndIf
if controls(btnUnderline).state then
	say (msg322, OT_STATUS) ;"underlined"
EndIf
if controls(btnAlignLeft).state then
	Say (msg324, OT_STATUS) ;"Aligned left"
EndIf
if controls(btnCenter).state then
	Say (msg326, OT_STATUS) ;"Centered"
EndIf
if controls(btnAlignRight).state then
	Say (msg328, OT_STATUS) ;"aligned right"
EndIf
let strBuffer = oExcel.commandbars(CBFormatting).controls(cboFont).text()
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
else
	Say (msg340, OT_STATUS) ; "Mixed style")
EndIf
let strBuffer = OExcel.commandbars(CBFormatting).controls(cboFontStyle).text()
if (strBuffer != "") then
	Say (strBuffer, OT_TEXT)
	Say (msg342, OT_MESSAGE) ; point
else
	Say (msg343, OT_MESSAGE) ;"Mixed point size")
EndIf
if (GetCharacterAttributes () & attrib_highlight) then
	Say (msg317, OT_STATUS) ; "Highlighted")
EndIf
if GetVerbosity()==beginner then
	say (msg390, OT_MESSAGE) ; cell number format is
endIf
say (oExcel.activeCell.NumberFormat, OT_TEXT)
EndScript

Script ReadCellComment ()
if OExcel.activeCell.comment.text!="" then
  Say (OExcel.activeCell.comment.text(), OT_STRING)
else
  Say (msg350, OT_MESSAGE);"No comment visible for this cell."
endIf
EndScript

String Function GetHyperlinkAddress(object hyperlink, int index)
var
string address
;msg422 = "link"
if hyperlink.address() !="" then
  let address=hyperlink.address()
elif hyperlink.subAddress() !="" then
  let address=hyperlink.subAddress()
elif index!=NoLinkIndex then
  let address=msg422+intToString(index+1)
else
  let address=msg422
endIf
return address
EndFunction

Script readCellHyperlink ()
var
string linkAddress
if oExcel.activeCell.hyperlinks.count > 0 then
	say (msg422, OT_MESSAGE) ; link
	let linkAddress=getHyperlinkAddress(oExcel.activeCell.hyperlinks(1),1)
	say (LinkAddress, OT_TEXT)
else
	say (msg354, OT_MESSAGE) ; no hyperlink associated with this cell
	endIf
EndScript

Script  WindowKeysHelp()
Say (msg1 , OT_HELP) ;"The following are some of the Excel Keyboard shortcuts"
Say (msg2, OT_HELP) ;"Auto sum, use Alt plus equals"
Say (msg3, OT_HELP) ;"Go to a certain cell, use F5"
Say (msg4, OT_HELP) ;"to start a formula, use equals"
Say (msg5, OT_HELP) ;"Select the entire column, use control plus space bar"
Say (msg6, OT_HELP)  ;"Select the entire row, use shift plus space bar"
Say (msg7, OT_HELP) ;"use standard window selecting keystrokes to select specific cells"
Say (msg8, OT_HELP) ;"move to edge of data regions, use control and arrow keys"
Say (msg9, OT_HELP) ;"Switch sheets, use control and page up or down"
Say (msg10, OT_HELP) ;"Move left or right one screen, use Alt plus Page down or up"
Say (msg11, OT_HELP) ;"to move to the end of any row or column"
Say (msg12, OT_HELP) ;" use the end key then the arrow key in the desired direction"
Say (msg13, OT_HELP) ;"selecting text, use combinations of control and shift with arrows, home and end"
Say (msg14, OT_HELP) ;"Insert the date, use control plus semicolon"
Say (msg15, OT_HELP) ;"Insert the time, use Control plus shift plus semicolon"
EndScript

Script  SelectRow()
 ;selects a row
{Shift+Space}
Say (msg16, OT_HELP) ;"selected entire row"
performScript saySelectedText()
EndScript

Script  SelectColumn()
;selects a column
{Control + Space}
Say (msg17, OT_HELP) ;"Selected entire column"
performScript saySelectedText()
EndScript

Script  FormulaMode()
var
string TheClass
let theClass=GetWindowClass(GetFocus())
{=}
; only want to say a msg if in worksheet area
if theClass==wc7 then
	;puts you in mode to type a formula
Say (msg20, OT_MESSAGE) ;"type in the formula and press enter"
else
	Say (msg95, OT_MESSAGE) ; equals
endIf
EndScript

Script  DateStamp()
;inserts date in cell
{Control + ;}
Say (msg21, OT_MESSAGE) ;"Inserted date"
If(GetVerbosity() == beginner) Then
         SayCharacter()
EndIf
EndScript

Script  TimeStamp()
;inserts time in cell
{Control + Shift + ;}
Say (msg22, OT_MESSAGE) ;"Inserted time"
If(GetVerbosity() == beginner) Then
         SayCharacter()
EndIf
EndScript

Script  SelectFromStartOfLine()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectFromStartOfLine() ; default
	return
endIf
;extends selection to left margin
{Shift+Home}
Say (msg34, OT_MESSAGE) ;"Extends the selection to beginning of row"
performScript saySelectedText()
EndScript

Script  SelectNextLine()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectNextLine()
	return
endIf
{shift+down arrow}
performScript saySelectedText()
EndScript

Script  SelectPriorLine()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectPriorLine()
	return
endIf
{shift+up arrow}
performScript saySelectedText()
EndScript

Script  SelectNextCharacter()
if GetWindowTypeCode(GetFocus())==wt_edit then
saystring("performing default")
; perform default function
	performScript selectNextCharacter()
	return
endIf
{shift+right arrow}
performScript saySelectedText()
EndScript

Script  SelectPriorCharacter()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectPriorCharacter()
	return
endIf
{shift+left arrow}
performScript saySelectedText()
EndScript

Script  SelectNextWord()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectNextWord()
	return
endIf
;selects range to right margin
{Control+Shift+RightArrow}
Say (msg36, OT_MESSAGE) ;"select range to right Margin"
performScript saySelectedText()
EndScript

Script  SelectPriorWord()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectPriorWord()
	return
endIf
;selects range to left margin
{Control+Shift+LeftArrow}
Say (msg37, OT_MESSAGE) ;"select range to Left Margin"
performScript saySelectedText()
EndScript

Script  SelectFromTop()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectFromTop()
	return
endIf
;selects to first cell in worksheet
{control+shift+home}
Say (msg38, OT_MESSAGE) ;"extends selection to first cell in worksheet, Top left"
performScript saySelectedText()
EndScript

Script  SelectToBottom()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectToBottom()
	return
endIf
;selects to last cell in worksheet
{control+shift+end}
Say (msg39, OT_MESSAGE) ;"extends selection to last cell in worksheet, Bottom Right"
performScript saySelectedText()
EndScript

Script  SelectRegion()
;selects current region
{Control+Shift+8}
Say (msg40, OT_MESSAGE) ;"Selected the current region"
performScript saySelectedText()
EndScript

Script  CopyToClipboard()
{Control + C}
If(GetVerbosity() == beginner) Then
Say (msg41, OT_MESSAGE) ;"Copied selected range"
elif (GetVerbosity() == intermediate) Then
Say (msg42, OT_MESSAGE) ;"Copied"
EndIf
EndScript

Script  CutToClipboard()
{Control + X}
If(GetVerbosity() == beginner) Then
Say (msg43, OT_MESSAGE) ;"Cut selected range"
elif (GetVerbosity() == intermediate) Then
Say (msg44, OT_MESSAGE) ;"Cut"
EndIf
EndScript


Script  PasteFromClipboard()
{Control + V}
Say (msg45, OT_MESSAGE) ;"Pasted selected range"
If(GetVerbosity() == intermediate) Then
Say (msg46, OT_MESSAGE) ;"Pasted"
EndIf
EndScript

Script  CollapseSelectionToActiveCell()
;collapses selection to active cell
{Shift+BackSpace}
if GetWindowClass(GetFocus())==wc7 then
	if GetVerbosity()==beginner then
		Say (msg49, OT_MESSAGE) ;"collapses selection to active cell"
	endIf
	readSelectedCells()
endIf
EndScript

Int Function IsSDMDialog ()
if (StringContains(GetWindowClass(GetRealWindow(GetCurrentWindow())), wc10)) then
	return TRUE
else
	return FALSE
endIf
EndFunction

String Function ColumnNumberToLetter (int i)
var
	int quotient,
	int remainder1,
	int remainder2
let i = i-1
let quotient = (i)/26
let remainder1 = quotient%27
let remainder2 = i%26
return SubString (alphabet, remainder1 + 1, 1) + msg773 + SubString (alphabet, remainder2 + 2, 1)
EndFunction

Void Function SayCellCoordinates (object theCell)
if (!theCell) then
	let theCell = GetCurrentCell ()
EndIf
if theCell then
say(theCell.addressLocal(false,false), ot_string)
	return
elif oExcel.activeChart.chartType !=0 then
	say(oExcel.activeChart.chartTitle.caption,ot_string)
EndIf
EndFunction

Function SayRangeCoordinates(object theRange)
var
int startRow,
int endRow,
int startCol,
int endCol,
int last,
string startTitle,
string endTitle

let last=theRange.cells.count

let startCol=theRange.cells(1).column
let endCol=theRange.cells(last).column
let startRow=theRange.cells(1).row
let endRow=theRange.cells(last).row

if (globalTitleReading & readColumnTitles) && (startCol !=endCol) then
; read column or both is set to true
	let startTitle=getColTitleOfCell(startCol,startRow)
	if startTitle ==msg773 || startTitle=="" then
		let startTitle=msg906 ; no column title
	endIf
	let endTitle=getColTitleOfCell(endCol,endRow)
	if endTitle==msg773 || endTitle=="" then
		let endTitle=msg906 ; no column title
	endIf
	sayUsingVoice(vctx_message,startTitle+msg710+endTitle,ot_message)
endIf
if (globalTitleReading & readRowTitles) && (startRow !=endRow) then
	let startTitle=getRowTitleOfCell(startCol,startRow)
	if startTitle ==msg773 || startTitle=="" then
		let startTitle=msg905 ; no row title
	endIf
	let endTitle=getRowTitleOfCell(endCol,endRow)
	if endTitle==msg773 || endTitle=="" then
		let endTitle=msg905 ; no row title
	endIf
	sayUsingVoice(vctx_message,startTitle+msg710+endTitle,ot_message)
endIf
sayCellCoordinates (theRange.Cells(1))
Say (msg710, OT_STRING) ; " through "
SayCellCoordinates (theRange.Cells(last))
EndFunction
object Function getVisibleSelection ()
var
object visibleRange,
object selectedRange,
object intersection
let visibleRange=oExcel.activeWindow.visibleRange
let selectedRange=oExcel.selection
let intersection=oExcel.intersect(selectedRange,visibleRange)
return intersection
EndFunction

Function ReadSelectedCells ()
var
	object selectedCells,
	int nCells,
	int index,
int nAreas,
int areaIndex

if (OExcel.selection.cells.count==0) && (oExcel.activeChart.chartType != 0) then
	readChart(OExcel.activeChart)
	return
elif !OExcel.activeCell() && caretVisible() then
; editing a comment
  sayCharacter()
  return
endIf
let selectedCells = oExcel.Selection.Cells
let nAreas=oExcel.selection.areas.count
if nAreas > 1 then
; more than one area selected
	if getVerbosity()==beginner then
		sayinteger(nAreas)
		say (msg415, OT_MESSAGE) ; "non contiguous ranges:"
	endIf
	let areaIndex=1
	while AreaIndex <= nAreas
		if oExcel.selection.areas(areaIndex).cells.count ==1 then
		sayCellCoordinates(oExcel.selection.areas(areaIndex).cells)
	else
		SayRangeCoordinates (oExcel.selection.areas(areaIndex).cells)
	endIf
		let areaIndex=areaIndex+1
	endWhile
	return
endIf
let nCells = selectedCells.Count
if (nCells == 1) then
; only 1 cell selected
	if globalTitleReading then
		if selectedCells.row !=globalPriorRow then
	; moved rows, update row title
			let globalRowOrColTitle=getRowTitle()
		elif selectedCells.column != globalPriorCol then
			let globalRowOrColTitle=getColTitle()
		endIf
	sayUsingVoice (vctx_message,globalRowOrColTitle, OT_TEXT)
	let globalPriorRow=selectedCells.row
	let globalPriorCol=selectedCells.column
	endIf
; say cell content immediately
	say (oExcel.activeCell.text, OT_TEXT)
	if (IsFormulaCell (selectedCells)) then
		SayUsingVoice (vctx_message, msg352a, ot_string) ; "has formula"
	endif
	if selectedCells.comment.text() !="" && GetVerbosity()==beginner then
		sayUsingVoice(vctx_message, msg351, ot_string) ; has comment
	endIf
	if selectedCells.hyperlinks.count > 0 then
	; cell has a hyperlink
		SayUsingVoice(vctx_message, msg352, ot_string)
	endIf
if (globalCellReadingVerbosity == 0) then
		SayCellCoordinates (selectedCells)
	endIf
	return
ElIf (nCells > 1) then
		SayRangeCoordinates (SelectedCells)
EndIf
; only want to read the selected cells which are visible or may cause JFW to crash if too many cells selected.
let selectedCells=getVisibleSelection()
let nCells=selectedCells.count
while index < nCells
	let index = index + 1
	Say (SelectedCells(index).Text, OT_TEXT)
EndWhile
EndFunction

Script ToggleCellReadingVerbosity ()
if (globalCellReadingVerbosity == 0) then
	let globalCellReadingVerbosity = 1;
	Say (msg680, OT_MESSAGE) ; cell content
else
	let globalCellReadingVerbosity = 0;
	Say (msg681, OT_MESSAGE) ; cell coordinates and content
EndIf
EndScript

Script AdjustJAWSVerbosity ()
var     string list
if (IsSpeechOff ()) then
         PerformScript MuteSynthesizer()
         return
endif
let list =
ExcelCellReadingVerbosityItem +
ExcelTitleReadingVerbosityItem +
ExcelSetTitlesRowItem+
ExcelSetTitlesColItem+
excelSetTotalColItem+
excelSetTotalRowItem+
ExcelSetMonitorCellItem+
ExcelClearDefinitionsItem+
VerbosityLevelItem +
         ScreenEchoItem +
         TypingEchoItem  +
         SayAllByItem +
PunctuationLevelItem+
FormatItem +
         GraphicsItem +
         AnsiCharsIncItem+
         BrailleVerbosityItem+

         MuteSynth
         DlgSelectScriptToRun (list, AdjustJawsVerbosityDialogName, false)
EndScript

Void Function SayFocusedWindow ()
var
string TheClass
let theClass=GetWindowClass(GetFocus())
if theClass==wc7 ||
	theClass==wc6 ||
	theClass==wcChartClass then
	saySheetName()
readSelectedCells()
else
	SayFocusedObject ()
endIf
EndFunction

Void Function SayBorderInfo (object border, int index)
var
int weight, ; note have to convert negatives to positives in this function
string tmp,
int LineStyle
if border.LineStyle==11 then
  return
endIf
if index==0 then
; treat all borders the same
  Say (msg388, OT_STRING); "Surrounding Border"
elif index==xlDiagonalDown then
  Say (msg380, OT_TEXT) ; "Diagonal Down"
elif index==xlDiagonalUp then
  say (msg381, OT_STRING) ; "Diagonal Up"
elif index==xlEdgeBottom then
  say (msg382, OT_STRING) ; "Bottom Edge"
elif index==xlEdgeLeft then
  say (msg383, OT_STRING) ; "Left Edge"
elif index==xlEdgeRight then
  say (msg384, OT_STRING) ; "Right Edge"
elif index==xlEdgeTop then
  say (msg385, OT_STRING) ;"Top Edge"
elif index==xlInsideHorizontal then
  say (msg386, OT_STRING) ; "Inside Horizontal"
elif index==xlInsideVertical then
  say (msg387, OT_STRING) ; "Inside Vertical"
else ; unknown border
  return
endIf
; weight constants
let weight=border.weight()
if weight < 0 then
  let tmp=intToString(weight)
  let tmp=substring(tmp,2,stringLength(tmp))
  let weight=stringToInt(tmp)
endIf
if weight==xlHairline then
  Say (msg370, OT_STRING) ; "Hairline"
elif weight==xlMedium then
  say (msg371, OT_STRING) ; "Medium"
elif weight==xlThick then
  say (msg372, OT_STRING) ; "Thick"
elif weight==xlThin then
  say (msg373, OT_STRING) ; "Thin"
endIf
; border line style constants from object browser
let LineStyle=border.LineStyle()
if lineStyle < 0 then
  let tmp=intToString(lineStyle)
  let tmp=subString(tmp,2, stringLength(tmp))
  let lineStyle=stringToInt(tmp)
endIf
if LineStyle < 0 then
endIf
if LineStyle==xlContinuous then
  say (msg360, OT_STRING) ; "Continuous"
elif LineStyle==xlDash then
  say (msg361, OT_STRING) ; "Dash"
elif LineStyle==xlDashDot then
  say (msg362, OT_STRING) ; "Dash Dot"
elif LineStyle==xlDashDotDot then
  say (msg363, OT_STRING) ; "Dash Dot Dot"
elif LineStyle==xlDot then
  say (msg364, OT_STRING) ; "Dot"
elif LineStyle==xlDouble then
  say (msg365, OT_STRING) ; "Double"
elif LineStyle==xlLineStyleNone then
  say (msg366, OT_STRING) ; "Grid Line"
elif LineStyle==xlSlantDashDot then
  say (msg367, OT_STRING) ; "Slant Dash Dot"
endIf
EndFunction

Script DescribeCellBorder ()
var
object borders,
object cell

let cell=GetCurrentCell()
let borders=cell.borders()

; say border as a whole
if ((borders(xlEdgeBottom).LineStyle ==
  borders(xlEdgeLeft).LineStyle) &&
  (borders(xlEdgeRight).lineStyle ==
  borders(xlEdgeTop).lineStyle) &&
  (borders(xlEdgeTop).lineStyle==borders(xlEdgeBottom).lineStyle)) &&
  ((borders(xlEdgeTop).weight() == borders(xlEdgeRight).weight() &&
  borders(xlEdgeBottom).weight() == borders(xlEdgeLeft).weight()) &&
  borders(xlEdgeTop).weight() == borders(xlEdgeBottom).weight()) then
  sayBorderInfo(borders(xlEdgeTop), 0)
else
  if borders(xlEdgeLeft) then
    sayBorderInfo(borders(xlEdgeLeft), XLEdgeLeft)
  endIf
  if borders(xlEdgeTop) then
    sayBorderInfo(borders(xlEdgeTop), XLEdgeTop)
  endIf
  if borders(xlEdgeRight) then
    sayBorderInfo(borders(xlEdgeRight), XLEdgeRight)
  endIf
  if borders(xlEdgeBottom) then
    SayBorderInfo(borders(xlEdgeBottom), XLEdgeBottom)
  endIf
endIf
EndScript

Script AutoFilter ()
var
string menu,
int selectedItem,
handle hwnd
if OExcel.activeSheet.autoFilterMode() then
; try turning it off
  speechOff()
  OExcel.selection.autofilter()
  pause()
  speechOn()
endIf
; now should be off, safe to start again.
Say (msg400, OT_MESSAGE) ; auto filter
;msg761 = "|"
let menu=allAutofilter+msg761+top10Autofilter+msg761+customAutofilter+msg761
let selectedItem=DlgSelectItemInList (menu, autofilterTitle, false)
if selectedItem==0 then
  return
endIf
speechOff()
OExcel.selection.autofilter()
; activate dropdown listbox
{alt+downarrow}
pause()
delay(5)
; look for selected item
let hwnd=FindTopLevelWindow (wc1, "")
if hwnd then
	if selectedItem==1 then
		if findString(hwnd, allAutoFilter, s_top, s_restricted) then
			; activate it.
			leftMouseButton()
			pcCursor()
			; all autofilter should be selected
		endIf
	elif selectedItem==2 then
		if findString(hwnd, top10AutoFilter, s_top, s_restricted) then
			; activate it.
			leftMouseButton()
			pcCursor()
			; focus should now be on top 10 Filter Dialog.
		EndIf
	elif selectedItem==3 then
		if findString(hwnd, customAutoFilter, s_top, s_restricted) then
			; activate it.
			leftMouseButton()
			pcCursor()
			; focus should now be on Custom Filter Dialog.
		endIf
	EndIf
else
say (msg401, OT_MESSAGE) ; "(Custom...) not found. Could not focus on Custom Filter Dialog."
; could not focus on it, something went wrong.
endIf
speechOn()
EndScript

Void Function IsFormulaCell (object theCell)
var
	string formula
let formula = theCell.Formula;
;msg762 = "="
if (StringContains (Formula, msg762)) then
	return TRUE
else
	return FALSE
endif
EndFunction

Int Function IsDialog ()
;wc12 = "#32770"
if (GetWindowClass(GetRealWindow(GetCurrentWindow())) == wc12) then
	return TRUE
else
	return FALSE
endif
EndFunction

Void Function ExcelHotKeyHelp ()
var
String strRealName,
String strPage,
int bSuccess
let strRealName = GetWindowName (GetRealWindow (GetFocus ()))
if stringContains(strRealName, msg899) then
	return true
;wn104 = "Format Cells"
elif (strRealName == wn104) then
	let strPage = GetDialogPageName ()
	Say (msg713, OT_HELP)	 ; "hot keys are as follows"
	;wn105 = "Number"
	if (strPage == wn105) then
		Say (msg714, OT_HELP)	; "category use alt c"
	;wn106 = "Alignment"
	elif (strPage == wn106) then
		Say (msg715, OT_STRING) ; "horizontal group"
		Say (msg716, OT_HELP) ; "general use alt g"
		Say (msg717, OT_HELP) ; "left use alt l"
		Say (msg718, OT_HELP) ; "center use alt c"
		Say (msg719, OT_HELP) ; "right use alt r"
		Say (msg720, OT_HELP) ; "fill use alt f"
		Say (msg721, OT_HELP) ; "justify use alt j"
		Say (msg722, OT_HELP) ; "center across selection use alt a"
		Say (msg723, OT_HELP) ; "vertical group"
		Say (msg724, OT_HELP) ; "top use alt t"
		Say (msg725, OT_HELP) ; "center use alt e"
		Say (msg726, OT_HELP)
		Say (msg727, OT_HELP) ; "justify use alt u"
		Say (msg728, OT_HELP) ; "wrap text use alt e"
		Say (msg729, OT_HELP) ; "orientation use alt n"
	;wn108 = "Font"
	elif (strPage == wn108) then
		Say (msg730, OT_HELP) ; "Font use alt f"
		Say (msg731, OT_HELP) ; "Font styles use alt o"
		Say (msg732, OT_HELP) ; "size use alt s"
		Say (msg733, OT_HELP) ; "strike through use alt k"
		Say (msg734, OT_HELP) ; "Superscript use alt e"
		Say (msg735, OT_HELP) ; "Subscript use alt b"
		Say (msg736, OT_HELP) ; "Underline use alt u"
		Say (msg739, OT_HELP) ; "Color use alt c"
		Say (msg737, OT_HELP) ; "Normal font use alt n"
	;wn109 = "Border"
	elif (strPage == wn109) then
		Say (msg738, OT_HELP) ; "Style group use alt e"
		Say (msg739, OT_HELP) ; "color use alt c"
		Say (msg740, OT_HELP) ; "border group"
		Say (msg741, OT_HELP) ; "outline use alt o"
		Say (msg742, OT_HELP) ; "left user alt l"
		Say (msg719, OT_HELP) ; "right use alt r"
		Say (msg724, OT_HELP) ; "top use alt t"
		Say (msg726, OT_HELP) ; "bottom use alt b"
	;wn110 = "Patterns"
	elif (strPage == wn110) then
		Say (msg743, OT_HELP)	; "Color palet use alt c"
		Say (msg744, OT_HELP) ; "pattern use alt p"
	;wn111 = "Protection"
	elif (strPage == wn111) then
		Say (msg745, OT_HELP) ; "locked use alt l"
		Say (msg746, OT_HELP) ; "hidden use alt i"
	endif
	return TRUE
else
	return FALSE
endif
EndFunction

Function GetRealWindow (handle hwnd)
;wn112 = "Print"
if (GetWindowName(GetTopLevelWindow(GetFocus())) == wn112) then
	return GetTopLevelWindow(hwnd)
else
	return GetRealWindow(hwnd)
endif
EndFunction

string Function GetChosenCoordinates (string ItemList, int index)
var
string tmp,
string item,
int count,
int startIndex,
int endIndex
if index ==0 then
  return ""
endif
let count =1
let startIndex=1
;msg761 = "|"
let endIndex=StringContains(itemlist,msg761)
if endIndex == 0 then
  let item= itemList ; only one item
  ;msg763 = ":"
  return subString(item,1, StringContains(item,msg763)-1)
EndIf
if index==1 then
  let item= substring(itemlist,startIndex,endIndex-1)
  ;msg763 = ":"
  return subString(item,1,stringContains(item,msg763)-1)
endIf
let startIndex=endIndex+1
while count < index
  let tmp=substring(itemlist,startIndex,stringLength(itemlist)-startIndex)
  let endIndex=StringContains(tmp,msg761)
  if endIndex==0 then ; end of item list
    let endIndex =stringLength(tmp)
  endIf
  let count=count+1
let startIndex=startIndex+endIndex
EndWhile
let endIndex=stringcontains(tmp,msg761)
if endIndex==0 then
  let endIndex=stringlength(tmp)
else
  let EndIndex=endIndex-1
endif
let item= substring(tmp,1,endIndex)
  return subString(item,1,stringContains(item,":")-1)
EndFunction

Script ListRow ()
var
object rowCells,
string coordinates,
string dlgTitle,
int choice,
string RowData,
string CellCoordinates,
string tmp,
int index,
int cellsWithData,
int count
let rowCells=oExcel.activeCell.entireRow
let count=rowCells.cells.count()
if count==0 then
; object model has failed!
	return
endIf
if getVerbosity()==beginner then
	say (msg395, OT_MESSAGE) ; "Please wait, collecting cell data."
endIf
let index=1
let cellsWithData=0
while index <= count
  	let tmp=rowCells.cells(index).text
	if tmp!="" then
		let coordinates=rowCells.cells(index).addressLocal(false,false)
		if globalTitleReading==readColumnTitles || globalTitleReading==readBothTitles then
		;msg764 = ": "
			let rowData=rowData+coordinates+msg764+getColTitleOfCell(index, rowCells.cells(index).row)+tmp+msg761
		else
			let rowData=rowData+coordinates+msg764+tmp+msg761 ; "|"
		endIf
	let cellsWithData=cellsWithData+1
	endIf
	let index=index+1
endWhile
if cellsWithData==0 then
	Say (msg393, OT_MESSAGE) ; no cells with data in current row.
	return
endIf
if globalTitleReading==readRowTitles || globalTitleReading==readBothTitles then
	let dlgTitle=getRowTitleOfCell(oExcel.activeCell.column, oExcel.activeCell.row)
endIf
let dlgTitle=dlgTitle+msg391
; remove trailing list delimiter to avoid getting empty last item in list
let rowData=StringLeft(rowData,stringLength(rowData)-1)
let choice=DlgSelectItemInList (rowData, dlgTitle, false)
if choice==0 then
	return
endIf
let cellCoordinates=getChosenCoordinates(rowData,choice)
oExcel.activeSheet.range(cellCoordinates).activate
readSelectedCells()
EndScript

Script ListColumn ()
var
string dlgTitle,
object ColumnCells,
string coordinates,
int choice,
string ColumnData,
string CellCoordinates,
string tmp,
int index,
int cellsWithData,
int count
let ColumnCells=oExcel.activeCell.entireColumn
let count=ColumnCells.cells.count()
if count==0 then
; object model has failed!
 return
endIf
if GetVerbosity()==beginner then
	say (msg395, OT_MESSAGE) ; "Please wait, collecting cell data."
endIf
let index=1
let cellsWithData=0
while index <=count && index < MaxRowsToSearch
  	let tmp=columnCells.cells(index).text
	if tmp!="" then
		let coordinates=columnCells.cells(index).addressLocal(false,false)
		if globalTitleReading==readRowTitles || globalTitleReading==readBothTitles then
		;msg764 = ": "
			let columnData=columnData+coordinates+msg764+getRowTitleOfCell(columnCells.cells(index).column, index)+tmp+msg761
		else
			let columnData=columnData+coordinates+msg764+tmp+msg761 ; "|"
		endIf
	let cellsWithData=cellsWithData+1
	endIf
	let index=index+1
endWhile
if cellsWithData==0 then
	Say (msg394, OT_HELP) ; no cells with data in current column
	return
endIf
if globalTitleReading==readColumnTitles || globalTitleReading==readBothTitles then
	let dlgTitle=getColTitleOfCell(oExcel.activeCell.column, oExcel.activeCell.row)
endIf
; remove trailing list delimiter to avoid getting empty last item in list
let columnData=stringLeft(columnData,stringLength(columnData)-1)
let dlgTitle=dlgTitle+msg392
let choice=DlgSelectItemInList (columnData, dlgTitle, false)
if choice==0 then
	return
endIf
let cellCoordinates=getChosenCoordinates(columnData,choice)
oExcel.activeSheet.range(cellCoordinates).activate
readSelectedCells()
EndScript

Script ListCellsWithComments ()
var
object visibleCells,
string coordinates,
int choice,
string rangeData,
string CellCoordinates,
string tmp,
int index,
int cellsWithComments,
int count

let visibleCells=oExcel.activeWindow.visibleRange
let count=visibleCells.cells.count()
if count==0 then
; object model has failed!
 return
endIf
if GetVerbosity()==beginner then
	say (msg395, OT_MESSAGE) ; "Please wait, collecting cell data."
endIf
let index=1
let cellsWithComments=0
while index <=count
  	let tmp=visibleCells.cells(index).comment.text
	if tmp!="" then
		let coordinates=visibleCells.cells(index).addressLocal(false,false)
		let rangeData=rangeData+coordinates+msg764+tmp+msg761
	let cellsWithComments=cellsWithComments+1
	endIf
	let index=index+1
endWhile
if cellsWithComments==0 then
	Say (msg394a, OT_MESSAGE) ; no cells with comments visible in active window
	return
endIf
let choice=DlgSelectItemInList (rangeData, msg394b, false)
if choice==0 then
	return
endIf
let cellCoordinates=getChosenCoordinates(rangeData,choice)
oExcel.activeSheet.range(cellCoordinates).activate
readSelectedCells()
EndScript

Script ListVisibleCellsWithData ()
var
object visibleCells,
string coordinates,
int choice,
string rangeData,
string CellCoordinates,
string tmp,
int index,
int cellsWithData,
int count

let visibleCells=oExcel.activeWindow.visibleRange
let count=visibleCells.cells.count()
if count==0 then
; object model has failed!
 return
endIf
if GetVerbosity()==beginner then
	say (msg395, OT_MESSAGE) ; "Please wait, collecting cell data."
endIf
let index=1
let cellsWithData=0
while index <=count
  	let tmp=visibleCells.cells(index).text
	if tmp!="" then
		let coordinates=visibleCells.cells(index).addressLocal(false,false)
		let rangeData=rangeData+coordinates+msg764+tmp+msg761
	let cellsWithData=cellsWithData+1
	endIf
	let index=index+1
endWhile
if cellsWithData==0 then
	Say (msg395a, OT_MESSAGE) ; no cells with data visible in active window
	return
endIf
; remove trailing list delimiter to avoid getting empty last item in list
let rangeData=stringLeft(rangeData,stringLength(rangeData)-1)
let choice=DlgSelectItemInList (rangeData, msg395b, false)
if choice==0 then
	return
endIf
let cellCoordinates=getChosenCoordinates(rangeData,choice)
oExcel.activeSheet.range(cellCoordinates).activate
readSelectedCells()
EndScript

Script ListCellsAtPageBreaks ()
var
object sheet,
object hBreakList,
object vBreakList,
int index,
int choice,
int hCount,
int vCount,
string coordinates,
string cellsAtPageBreaks,
string cellText
say (msg414, OT_MESSAGE) ; collecting cells at page breaks
let cellsAtPageBreaks=""
let sheet=oExcel.activeSheet
let hBreakList=sheet.hPageBreaks
let hCount=hBreakList.count
let vBreakList=sheet.vPageBreaks
let vCount=vBreakList.count
if hCount+vCount==0 then
	Say (msg747, OT_MESSAGE) ; "no page breaks."
	return
endIf

let index=1
if hCount > 0 then
	while index <= hCount
		let coordinates=hBreakList(index).location.addressLocal(false,false)
		let cellText=hBreakList(index).location.text
		let cellsAtPageBreaks=cellsAtPageBreaks+coordinates+msg764+cellText+msg412+msg761
		let index=index+1
	endWhile
endIf
let index=1
if vCount > 0 then
	while index <= vCount
		let coordinates=vBreakList(index).location.addressLocal(false,false)
		let cellText=vBreakList(index).location.text
		let cellsAtPageBreaks=cellsAtPageBreaks+coordinates+cellText+msg413+msg761
		let index=index+1
	endWhile
endIf
if cellsAtPageBreaks =="" then
	return
endIf
; remove trailing list delimiter to avoid getting empty last item in list
let cellsAtPageBreaks=stringLeft(cellsAtPageBreaks,stringLength(CellsAtPageBreaks)-1)
let choice=DlgSelectItemInList (cellsAtPageBreaks, msg411, false)
if choice==0 then
	return
endIf
let Coordinates=getChosenCoordinates(cellsAtPagebreaks,choice)
oExcel.activeSheet.range(Coordinates).activate
readSelectedCells()
EndScript

Script ReportGridlineStatus ()
if OExcel.activeWindow.DisplayGridLines then
	Say (msg397, OT_STATUS) ; "grid lines on"
else
	Say (msg396, OT_STATUS) ; "Grid lines off."
endIf
EndScript
int Function countCellsWithDataInVisibleRange ()
var
object visibleRange,
int CellsWithData
let visibleRange=oExcel.activeWindow.visibleRange
let cellsWithData=oExcel.evaluate(msg398e+visibleRange.addressLocal+msg398f)
return cellsWithData
EndFunction

Script SayVisibleRangeCoordinates ()
var
object visibleRange,
string tmp, ; need tmp as appending a string to an object's property even though it is a string yields an error
string coordinates,
string cellText

let visibleRange=oExcel.activeWindow.visibleRange
if visibleRange.cells.count > 0 then
	if getVerbosity()==beginner then
		Say (msg398, OT_MESSAGE) ; visible range is
	endIf
else
	say (msg398b, OT_MESSAGE) ; no visible range in active window
	return
endIf
let coordinates=visibleRange.cells(1).addressLocal(false,false)
let tmp=visibleRange.cells(visibleRange.cells.count).addressLocal(false,false)
let coordinates=coordinates+msg398a+tmp
say (coordinates, OT_TEXT)
if GetVerbosity()==beginner then
	say(intToString(countCellsWithDataInVisibleRange())+msg398c+intToString(visibleRange.cells.count)+msg398d, ot_string) ; x of the y visible cells contain data
endIf
EndScript

string Function getFormControlDescription (object shape)
var
int type
let type=shape.formControlType
if type==xlButtonControl then
	return msg670 ; "Button Control", ; =0,
elif type==xlCheckbox then
	return msg671 ; "CheckBox", ; =1,
elif type==xlDropdown then
	return msg672 ; "Dropdown", ; =2,
elif type==xlEditBox then
	return msg673 ; "Edit Box", ; =3,
elif type==xlGroupBox then
	return msg674 ; "Group Box", ; =4,
elif type==xlLabel then
	return msg675 ; "Label", ; =5,
elif type==xlListBox then
	return msg676 ; "List Box", ; =6,
elif type ==xlOptionButton then
	return msg677 ; "Option Button", ; =7,
elif type==xlScrollBar then
	return msg678 ; "Scroll Bar", ; =8,
elif type==xlSpinner then
	return msg679 ; "Spinner", ; =9
endIf
EndFunction

String Function GetOleObjDescription (object shape)
var
string description,
string ObjName,
object OleObj,
string progId

let OleObj=shape.OleFormat.object.application()
let ProgId=shape.OleFormat.ProgId()
if ProgId==Excel97sheet then
  return GetExcel97WorksheetCell(OleObj) ; excel worksheet cell info
elif progId==Excel97Chart then
  return msg660a ; Excel 97 Chart
elif progId==MsGraphChart8 then
  return msg661 ; Ms Graph 97 chart
elif progId==PaintPicture then
  return msg662 ; bitmap picture
elif ProgId==MsClipartGallery2 then
  return msg663 ; Ms Clipart
elif progId==word97doc then
  return msg664 ; word 97 document
elif progId==Ppt97Show then
  return msg665 ; Ppt 97 presentation
elif progId==Ppt97Slide then
  return msg665a ; Ppt 97 slide
endIf
let oleObj=shape.oleFormat.object
let description=getFormControlDescription(oleObj)
if description=="" then
	let description=msg647
endIf
return description
EndFunction

String Function GetAutoshapeDescription (object shape)
var
int type

let type=shape.autoshapeType()
if type==MsoShape16pointStar then
	return msg594
elif type==MsoShape24pointStar then
	return msg595
elif type==MsoShape32pointStar then
	return msg596
elif type==MsoShape4pointStar then
	return msg591
elif type==MsoShape5pointStar then
	return msg592
elif type==MsoShape8pointStar then
	return msg593
elif type==MsoShapeActionBtnBackorPrev then
	return msg629
elif type==MsoShapeActionButtonBeginning then
	return msg631
elif type==MsoShapeActionButtonCustom then
	return msg625
elif type==MsoShapeActionButtonDocument then
	return msg634
elif type==MsoShapeActionButtonEnd then
	return msg632
elif type==MsoShapeActionBtnForwardorNxt then
	return msg630
elif type==MsoShapeActionButtonHelp then
	return msg627
elif type==MsoShapeActionButtonHome then
	return msg626
elif type==MsoShapeActionBtnInfo then
	return msg628
elif type==MsoShapeActionButtonMovie then
	return msg636
elif type==MsoShapeActionButtonReturn then
	return msg633
elif type==MsoShapeActionButtonSound then
	return msg635
elif type==MsoShapeArc then
	return msg525
elif type==MsoShapeBalloon then
	return msg637
elif type==MsoShapeBentArrow then
	return msg541
elif type==MsoShapeBentUpArrow then
	return msg544
elif type==MsoShapeBevel then
	return msg515
elif type==MsoShapeBlockArc then
	return msg520
elif type==MsoShapeCan then
	return msg513
elif type==MsoShapeChevron then
	return msg552
elif type==MsoShapeCircularArrow then
	return msg560
elif type==MsoShapeCloudCallout then
	return msg608
elif type==MsoShapeCross then
	return msg511
elif type==MsoShapeCube then
	return msg514
elif type==MsoShapeCurvedDownArrow then
	return msg548
elif type==MsoShapeCurvedDownRibbon then
	return msg600
elif type==MsoShapeCurvedLeftArrow then
	return msg546
elif type==MsoShapeCurvedRightArrow then
	return msg545
elif type==MsoShapeCurvedUpArrow then
	return msg547
elif type==MsoShapeCurvedUpRibbon then
	return msg599
elif type==MsoShapeDiamond then
	return msg504
elif type==MsoShapeDonut then
	return msg518
elif type==MsoShapeDoubleBrace then
	return msg527
elif type==MsoShapeDoubleBracket then
	return msg526
elif type==MsoShapeDoubleWave then
	return msg604
elif type==MsoShapeDownArrow then
	return msg536
elif type==MsoShapeDownArrowCallout then
	return msg556
elif type==MsoShapeDownRibbon then
	return msg598
elif type==MsoShapeExplosion1 then
	return msg589
elif type==MsoShapeExplosion2 then
	return msg590
elif type==MsoShapeFlowchartAltProcess then
	return msg562
elif type==MsoShapeFlowchartCard then
	return msg575
elif type==MsoShapeFlowchartCollate then
	return msg579
elif type==MsoShapeFlowchartConnector then
	return msg573
elif type==MsoShapeFlowchartData then
	return msg564
elif type==MsoShapeFlowchartDecision then
	return msg563
elif type==MsoShapeFlowchartDelay then
	return msg584
elif type==MsoShapeFlowchartDirAccStorage then
	return msg587
elif type==MsoShapeFlowchartDisplay then
	return msg588
elif type==MsoShapeFlowchartDocument then
	return msg567
elif type==MsoShapeFlowchartExtract then
	return msg581
elif type==MsoShapeFlowchartIntStorage then
	return msg566
elif type==MsoShapeFlowchartMagneticDisk then
	return msg586
elif type==MsoShapeFlowchartManualInput then
	return msg571
elif type==MsoShapeFlowchartManualOp then
	return msg572
elif type==MsoShapeFlowchartMerge then
	return msg582
elif type==MsoShapeFlowchartMultidocument then
	return msg568
elif type==MsoShapeFlowchartOffpageCon then
	return msg574
elif type==MsoShapeFlowchartOr then
	return msg578
elif type==MsoShapeFlowchartPredefProc then
	return msg565
elif type==MsoShapeFlowchartPreparation then
	return msg570
elif type==MsoShapeFlowchartProcess then
	return msg561
elif type==MsoShapeFlowchartPunchedTape then
	return msg576
elif type==MsoShapeFlowchartSeqAccStorage then
	return msg585
elif type==MsoShapeFlowchartSort then
	return msg580
elif type==MsoShapeFlowchartStoredData then
	return msg583
elif type==MsoShapeFlowchartSummingJunct then
	return msg577
elif type==MsoShapeFlowchartTerminator then
	return msg569
elif type==MsoShapeFoldedCorner then
	return msg516
elif type==MsoShapeHeart then
	return msg521
elif type==MsoShapeHexagon then
	return msg510
elif type==MsoShapeHorizontalScroll then
	return msg602
elif type==MsoShapeIsoscelesTriangle then
	return msg507
elif type==MsoShapeLeftArrow then
	return msg534
elif type==MsoShapeLeftArrowCallout then
	return msg554
elif type==MsoShapeLeftBrace then
	return msg531
elif type==MsoShapeLeftBracket then
	return msg529
elif type==MsoShapeLeftRightArrow then
	return msg537
elif type==MsoShapeLeftRightArrowCallout then
	return msg557
elif type==MsoShapeLeftRightUpArrow then
	return msg540
elif type==MsoShapeLeftUpArrow then
	return msg543
elif type==MsoShapeLightningBolt then
	return msg522
elif type==MsoShapeLineCallout1 then
	return msg609
elif type==MsoShapeLineCallout1AccentBar then
	return msg613
elif type==MsoShapeLnCallout1BordAccBar then
	return msg621
elif type==MsoShapeLineCallout1NoBorder then
	return msg617
elif type==MsoShapeLineCallout2 then
	return msg610
elif type==MsoShapeLineCallout2AccentBar then
	return msg614
elif type==MsoShapeLnCallout2BordAccBar then
	return msg622
elif type==MsoShapeLineCallout2NoBorder then
	return msg618
elif type==MsoShapeLineCallout3 then
	return msg611
elif type==MsoShapeLineCallout3AccentBar then
	return msg615
elif type==MsoShapeLnCallout3BordAccBar then
	return msg623
elif type==MsoShapeLineCallout3NoBorder then
	return msg619
elif type==MsoShapeLineCallout4 then
	return msg612
elif type==MsoShapeLineCallout4AccentBar then
	return msg616
elif type==MsoShapeLnCallout4BordAccBar then
	return msg624
elif type==MsoShapeLineCallout4NoBorder then
	return msg620
elif type==MsoShapeMoon then
	return msg524
elif type==MsoShapeNoSymbol then
	return msg519
elif type==MsoShapeNotchedRightArrow then
	return msg550
elif type==MsoShapeNotPrimitive then
	return msg638
elif type==MsoShapeOctagon then
	return msg506
elif type==MsoShapeOval then
	return msg509
elif type==MsoShapeOvalCallout then
	return msg607
elif type==MsoShapeParallelogram then
	return msg502
elif type==MsoShapePentagon then
	return msg551
elif type==MsoShapePlaque then
	return msg528
elif type==MsoShapeQuadArrow then
	return msg539
elif type==MsoShapeQuadArrowCallout then
	return msg559
elif type==MsoShapeRectangle then
	return msg501
elif type==MsoShapeRectangularCallout then
	return msg605
elif type==MsoShapeRegularPentagon then
	return msg512
elif type==MsoShapeRightArrow then
	return msg533
elif type==MsoShapeRightArrowCallout then
	return msg553
elif type==MsoShapeRightBrace then
	return msg532
elif type==MsoShapeRightBracket then
	return msg530
elif type==MsoShapeRightTriangle then
	return msg508
elif type==MsoShapeRoundedRectangle then
	return msg505
elif type==MsoShapeRoundedRectCallout then
	return msg606
elif type==MsoShapeSmileyFace then
	return msg517
elif type==MsoShapeStripedRightArrow then
	return msg549
elif type==MsoShapeSun then
	return msg523
elif type==MsoShapeTrapezoid then
	return msg503
elif type==MsoShapeUpArrow then
	return msg535
elif type==MsoShapeUpArrowCallout then
	return msg555
elif type==MsoShapeUpDownArrow then
	return msg538
elif type==MsoShapeUpDownArrowCallout then
	return msg558
elif type==MsoShapeUpRibbon then
	return msg597
elif type==MsoShapeUTurnArrow then
	return msg542
elif type==MsoShapeVerticalScroll then
	return msg601
 elif type==MsoShapeWave then
	return msg603
else
	return shape.name()
endIf
EndFunction

string Function GetShapeTopLeftAndBottomRight (object shape)
var
string topLeftCoordinates,
string bottomRightCoordinates
let topLeftCoordinates=shape.topLeftCell.addressLocal(false,false)
let bottomRightCoordinates=shape.bottomRightCell.addressLocal(false,false)
return topLeftCoordinates+msg765+bottomRightCoordinates
EndFunction


string Function GetShapeDescription (object shape)
var
string tmp
if shape.type()==MsoAutoShape then
  return GetAutoshapeDescription(shape)
elif shape.type()==msoEmbeddedOLEObject then
  return GetOleObjDescription(shape)
elif shape.type()==msoCallout then
  return msg642 ;"callout", ; 2,
elif shape.type()==msoChart then
; must assign value to tmp or strange results
	let tmp=shape.name
; must query chartObjects collection as shape does not inherit all properties even though its type is msoChart.
	if oExcel.activeSheet.chartObjects(tmp).chart.chartTitle.caption!="" then
		return msg643+msg764+oExcel.activeSheet.chartObjects(tmp).chart.chartTitle.caption
	else
		return msg643+msg764+tmp ;"chart" ; 3,
	endIf
elif shape.type()==msoComment then
  return msg644 ;"comment", ; 4,
elif shape.type()==msoFormControl then
  return getFormControlDescription(shape) ; msg648 ;"form control", ; 8,
elif shape.type()==msoFreeform then
  return msg645 ;"freeform", ; 5,
elif shape.type()==msoGroup then
  return msg646 ;"group", ; 6,
elif shape.type()==msoLine then
  return msg649 ;"line", ; 9,
elif shape.type()==msoLinkedOLEObject then
  return msg650 ;"linked OLE object", ; 10,
elif shape.type()==msoLinkedPicture then
  return msg651 ;"linked picture", ; 11,
elif shape.type()==msoOLEControlObject then
  return msg652 ;"OLE control object", ; 12,
elif shape.type()==msoPicture then
  return msg653 ;"picture", ; 13,
elif shape.type()==msoTextBox then
  return msg657 ;"text box" ; 17,
else
	return shape.name()
endIf
EndFunction

Script SelectWorksheetObjects ()
var
object shapes,
object sheet,
object shape,
string shapeDescription,
string shapeName,
string shapeText,
string shapeList,
int count,
int choice,
int index
if GetVerbosity()==beginner then
	say (msg419, OT_MESSAGE) ; please wait, collecting shapes
endIf
let sheet=oExcel.activeSheet
let shapes=sheet.shapes
let index=1
let count=shapes.count
if count==0 then
	Say (msg420a, OT_MESSAGE) ; "Worksheet contains no shapes."
	return
EndIf
while index <= count
	let shape=shapes(index)
	let shapeText=shape.textFrame.characters.text
	let shapeName=getShapeDescription(shape)
	let shapeDescription=shapeText+msg773+ShapeName
	let shapeList=shapeList+getShapeTopLeftAndBottomRight(shape)+shapeDescription
	if index < count then
		let shapeList=shapeList+msg761 ; append the list delimiter.
	endIf
	let index=index+1
endWhile
let choice=DlgSelectItemInList (shapeList, msg418, false)
if choice==0 then
	return
	endIf
Say (msg421, OT_STATUS) ; "selecting"
say (getShapeDescription(shapes(choice)), OT_STATUS)
	shapes(choice).select
if shapes(choice).onAction !="" then
	oExcel.run(shapes(choice).onAction)
endIf
EndScript

Script SelectHyperlink ()
var
object hyperlink,
string address,
string SubAddress,
int Index,
string LinkList,
int Count,
int LinkSelected,
object sheet
let sheet=oExcel.activeSheet
let Count=sheet.hyperlinks.count()
if Count < 1 then
  say (msg423, OT_MESSAGE) ; no hyperlinks on slide
  return
elif getVerbosity()==beginner then
	say (msg428, OT_MESSAGE) ; please wait, collecting hyperlinks
endIf
let Index=1
while Index <= Count
  let hyperlink=sheet.hyperlinks(Index)
  let address=GetHyperlinkAddress(hyperlink, index)
  ;msg761 = "|"
  let LinkList=LinkList+address+msg761
  let Index=Index+1
EndWhile
let LinkSelected=DlgSelectItemInList (LinkList, msg424, false)
if linkSelected > 0 then
  let address=sheet.hyperlinks(linkSelected).address()
  let subAddress=sheet.hyperlinks(linkSelected).SubAddress()
  if GetVerbosity()==beginner then
    Say (msg425, OT_MESSAGE) ; hyperlink selected
  endIf
  oExcel.activeWorkbook.followHyperlink(address,subAddress)
endIf
EndScript

int Function BrailleBuildCell ()
var
string coordinates,
string tmp,
	object selectedCells,
	int nCells,
int nCellsInArea,
int nAreas,
int areaIndex,
	int index

let selectedCells = oExcel.Selection.Cells
let nCells = selectedCells.Count
let nAreas=oExcel.selection.areas.count
if nAreas > 1 then
; more than one area selected
	let areaIndex=1
	while AreaIndex <= nAreas
		if oExcel.selection.areas(areaIndex).cells.count ==1 then
; multiple areas, but this area only has one cell selected
	  let coordinates=oExcel.selection.areas(areaIndex).cells(1).addressLocal(false,false)
		BrailleAddString (coordinates, 0, 0, attrib_underline)
	else
; this area has a range of cells selected
		let nCellsInArea=oExcel.selection.areas(areaIndex).count
	let coordinates= oExcel.selection.areas(areaIndex).cells(1).addressLocal(false,false)
	let coordinates=coordinates+msg765 ; "-"
	let tmp=oExcel.selection.areas(areaIndex).cells(nCellsInArea).addressLocal(false,false)
	let coordinates=coordinates+tmp
	BrailleAddString (coordinates, 0, 0, attrib_underline)
	endIf
		let areaIndex=areaIndex+1
	endWhile ; end of area loop
	return true
endIf
; just one cell selected
if (nCells == 1) then
; if title reading on, Braille the appropriate title
	if globalTitleReading then
		if selectedCells.row !=globalPriorRow then
	; moved rows, update row title
			let globalRowOrColTitle=getRowTitle()
		elif selectedCells.column != globalPriorCol then
			let globalRowOrColTitle=getColTitle()
		endIf
		let globalPriorRow=selectedCells.row
		let globalPriorCol=selectedCells.column
		BrailleAddString(getColTitle(),0,0,0)
		BrailleAddString(getRowTitle(),0,0,0)
	endIf
	let coordinates= selectedCells.addressLocal(false,false)
	let coordinates=coordinates+msg763
	BrailleAddString (coordinates, 0, 0, 0)
	BrailleAddString(selectedCells.text,0,0,0)
	if (IsFormulaCell (selectedCells)) then
	BrailleAddString(selectedCells.formula,0,0,0)
	endif
	if selectedCells.hyperlinks.count > 0 then
	; has hyperlink attached to cell
	;msg764 = ": "
	BrailleAddString(msg422+msg764+GetHyperlinkAddress(selectedCells.hyperlinks(1),1), 0,0,0)
	endIf
	if selectedCells.comment.text !="" then
	brailleAddString(msg351a,0,0,0)
		BrailleAddString(selectedCells.comment.text,0,0,0) ; has comment
	endIf
	if globalMonitorCellCoordinates!="" then
	BrailleAddString(globalMonitorCellCoordinates+":",0,0,0)
	BrailleAddString(oExcel.activeSheet.range(globalMonitorCellCoordinates).text,0,0,0)
	endIf
	return true
	ElIf (nCells > 1) then
; only one area but multiple cells selected
; get coordinates of first cell in range
; only want visible selection, avoid crash if whole column is selected
let selectedCells=getVisibleSelection()
let nCells=selectedCells.count
	let coordinates= selectedCells(1).addressLocal(false,false)
	;msg765 = "-"
	let coordinates=coordinates+msg765
; get coordinates of last cell in range
	let tmp=selectedCells(nCells).addressLocal(false,false)
	let coordinates=coordinates+tmp+msg764
	BrailleAddString (coordinates, 0, 0, 0)
; display up to 25 of the selected cells
	let index=1
	while index <=nCells
		BrailleAddString(SelectedCells(index).Text,0,0,attrib_highlight)
		let index = index + 1
	EndWhile
	return true
EndIf
EndFunction

int Function BrailleBuildLine ()
if not BrailleBuildLine() then
	return brailleBuildCell()
endIf
EndFunction

Script toggleTitleReadingVerbosity ()
if globalTitleReading==readBothTitles then
	Say (msg682, OT_STATUS) ; title reading off
	let globalTitleReading=readNoTitles
elif globalTitleReading==readNoTitles then
	Say (msg683a, OT_MESSAGE) ; read column titles
	let globalTitleReading=readColumnTitles
elif globalTitleReading==readColumnTitles then
	Say (msg683b, OT_MESSAGE) ; read row titles
	let globalTitleReading=readRowTitles
else
	Say (msg683c, OT_MESSAGE) ; read both titles
	let globalTitleReading=readBothTitles
endIf
EndScript

Script setColTitlesToRowRange ()
var
int count
Say (msg684, OT_MESSAGE) ; setting column titles to row range
let globalTitleRowStart=oExcel.selection.cells(1).row
let count=oExcel.selection.cells.count
let globalTitleRowEnd=oExcel.selection.cells(count).row
if count > 1 then
	Say (IntToString(globalTitleRowStart)+msg689+intToString(globalTitleRowEnd), OT_STRING)
else
	sayInteger(globalTitleRowStart)
endIf
; turn column title reading on
let globalTitleReading=globalTitleReading | ReadColumnTitles
EndScript

Script setRowTitlesToColumnRange ()
var
int count
Say (msg685, OT_MESSAGE) ; setting row titles to column
let globalTitleColStart=oExcel.selection.cells(1).column
let count=oExcel.selection.cells.count
let globalTitleColEnd=oExcel.selection.cells(count).column
if count > 1 then
	Say (columnNumberToLetter(globalTitleColStart)+msg689+columnNumberToLetter(globalTitleColEnd), OT_STRING)
else
	Say (columnNumberToLetter(globalTitleColStart), OT_STRING)
endIf
; turn row title reading on
let globalTitleReading=globalTitleReading | readRowTitles
EndScript

int Function findSumFormulaInRange (object cells)
var
int index,
int count,
int totalColIndex
let count=cells.count
let index=1
while index <=count && index < maxRowsToSearch
	if stringContains(cells(index).formula, GlobalTotalFormulaStr) then
let totalColIndex=index
		let index=count
	endIf
	let index=index+1
endWhile
return totalColIndex
EndFunction

Script sayRowTitle ()
Say (getRowTitle(), OT_STRING)
EndScript

Script sayColumnTitle ()
Say (getColTitle(), OT_STRING)
EndScript

Script ReadRowTotal ()
var
int currentRow
let currentRow=oExcel.activeCell.row
if globalTotalColumn==0 then
	let globalTotalColumn=FindSumFormulaInRange(oExcel.activeSheet.rows(currentRow).cells)
	if globalTotalColumn ==0 then
; no sum formula, can't say the total
	Say (msg690, OT_MESSAGE) ; "no totals column defined and I cannot find a sum formula in the current row."
	return
	endIf
endIf
if GetVerbosity()==beginner then
	say (msg692, OT_MESSAGE) ; column total equals
endIf
Say (OExcel.activeSheet.rows(currentRow).cells(globalTotalColumn).text, OT_STRING)
EndScript

Script ReadColumnTotal ()
var
int currentColumn
let currentColumn=oExcel.activeCell.column
if globalTotalRow==0 then
	let globalTotalRow=FindSumFormulaInRange(oExcel.activeSheet.columns(currentColumn).cells)
	if globalTotalRow ==0 then
; no sum formula, can't say the total
	Say (msg691, OT_MESSAGE) ; no totals row defined and I can't find a sum formula ...
	return
	endIf
endIf
if getVerbosity()==beginner then
	Say (msg693, OT_MESSAGE) ; column total equals
endIf
Say (OExcel.activeSheet.columns(currentColumn).cells(globalTotalRow).text, OT_STRING)
EndScript



Script ReadMonitorCell ()
if globalMonitorCellCoordinates=="" then
	Say (msg698, OT_MESSAGE) ; "No monitor cell defined."
	return
endIf
if getVerbosity()==beginner then
	say (globalMonitorCellCoordinates, OT_MESSAGE)
	say (msg95, OT_MESSAGE) ; equals
endIf
Say (oExcel.activeSheet.range(globalMonitorCellCoordinates).text, OT_STRING)
EndScript

Script setTotalColumnToCurrent ()
var
int currentColumn
let currentColumn=oExcel.activeCell.column
say (msg694+columnNumberToLetter(currentColumn), OT_STRING)
let globalTotalColumn=currentColumn
EndScript

Script setTotalRowToCurrent ()
var
int currentRow
	let currentRow=oExcel.activeCell.row
say (msg695+intToString(currentRow), OT_STRING)
let globalTotalRow=currentRow
EndScript

Script setMonitorCellToCurrent ()
var
string cellCoordinates
	let cellCoordinates=oExcel.activeCell.addressLocal(false,false)
say (msg696+cellCoordinates, OT_STRING)
let globalMonitorCellCoordinates=cellCoordinates
EndScript

Script clearAllDefinitions ()
say (msg697, OT_MESSAGE) ; clearing ...
let globalTitleRowStart=0
let globalTitleRowEnd=0
let globalTitleColStart=0
let globalTitleColEnd=0
let globalTotalRow=0
let globalTotalColumn=0
let globalMonitorCellCoordinates=""
let globalTitleReading=readNoTitles
EndScript

Script TabKey ()
{tab}
If GetWindowClass(GetFocus())==wc7 || getWindowClass(GetFocus())==wc6 then
	ReadSelectedCells()
EndIf
EndScript

Script backTabKey ()
{shift+tab}
If GetWindowClass(GetFocus())==wc7 || getWindowClass(GetFocus())==wc6 then
   ReadSelectedCells()
EndIf
EndScript

Int Function exp (int base, int n)
var int i, int thePower
if n then
	let i = 1
	let thePower = 1
	while (i <= n)
		let thePower = thePower * base
		let i = i+1
	EndWhile
	return thePower
else return 1 EndIf
EndFunction

int Function ColumnLetterToNumber (string strCol)
var int nResult, int count, int length, int n, string strTemp
let nResult = 0
let count = 0
let length = StringLength (strCol)
while (count < length)
	let strTemp = SubString (strCol, length-count, 1)
	let n = StringContains (alphabet, strTemp)-1
	if n then
		let nResult = nResult + exp(26, count)*n
	EndIf
	let count = count + 1
EndWhile
return nResult
EndFunction

String Function getChartTypeDescription (object chart)
var
int type,
string description
let type=chart.chartType
if type < 0 then
; convert to positive
	let type=type*(-1)
endIf
if type==xl3DArea then
	let description=msg821
elif type==xl3DAreaStacked then
	let description=msg822
elif type==xl3DAreaStacked100 then
	let description=msg823
elif type==xl3DBarClustered then
	let description=msg824
elif type==xl3DBarStacked then
	let description=msg825
elif type==xl3DBarStacked100 then
	let description=msg826
elif type==xl3DColumn then
	let description=msg827
elif type==xl3DColumnClustered then
	let description=msg828
elif type==xl3DColumnStacked then
	let description=msg829
elif type==xl3DColumnStacked100 then
	let description=msg830
elif type==xl3DLine then
	let description=msg831
elif type==xl3DPie then
	let description=msg832
elif type==xl3DPieExploded then
	let description=msg833
elif type==xlArea then
	let description=msg834
elif type==xlAreaStacked then
	let description=msg835
elif type==xlAreaStacked100 then
	let description=msg836
elif type==xlBarClustered then
	let description=msg837
elif type==xlBarOfPie then
	let description=msg838
elif type==xlBarStacked then
	let description=msg839
elif type==xlBarStacked100 then
	let description=msg840
elif type==xlBubble then
	let description=msg841
elif type==xlBubble3DEffect then
	let description=msg842
elif type==xlColumnClustered then
	let description=msg843
elif type==xlColumnStacked then
	let description=msg844
elif type==xlColumnStacked100 then
	let description=msg845
elif type==xlConeBarClustered then
	let description=msg846
elif type==xlConeBarStacked then
	let description=msg847
elif type==xlConeBarStacked100 then
	let description=msg848
elif type==xlConeCol then
	let description=msg849
elif type==xlConeColClustered then
	let description=msg850
elif type==xlConeColStacked then
	let description=msg851
elif type==xlConeColStacked100 then
	let description=msg852
elif type==xlCylinderBarClustered then
	let description=msg853
elif type==xlCylinderBarStacked then
	let description=msg854
elif type==xlCylinderBarStacked100 then
	let description=msg855
elif type==xlCylinderCol then
	let description=msg856
elif type==xlCylinderColClustered then
	let description=msg857
elif type==xlCylinderColStacked then
	let description=msg858
elif type==xlCylinderColStacked100 then
	let description=msg859
elif type==xlDoughnut then
	let description=msg860
elif type==xlDoughnutExploded then
	let description=msg861
elif type==xlLine then
	let description=msg862
elif type==xlLineMarkers then
	let description=msg863
elif type==xlLineMarkersStacked then
	let description=msg864
elif type==xlLineMarkersStacked100 then
	let description=msg865
elif type==xlLineStacked then
	let description=msg866
elif type==xlLineStacked100 then
	let description=msg867
elif type==xlPie then
	let description=msg868
elif type==xlPieExploded then
	let description=msg869
elif type==xlPieOfPie then
	let description=msg870
elif type==xlPyramidBarClustered then
	let description=msg871
elif type==xlPyramidBarStacked then
	let description=msg872
elif type==xlPyramidBarStacked100 then
	let description=msg873
elif type==xlPyramidCol then
	let description=msg874
elif type==xlPyramidColClustered then
	let description=msg875
elif type==xlPyramidColStacked then
	let description=msg876
elif type==xlPyramidColStacked100 then
	let description=msg877
elif type==xlRadar then
	let description=msg878
elif type==xlRadarFilled then
	let description=msg879
elif type==xlRadarMarkers then
	let description=msg880
elif type==xlStockHLC then
	let description=msg881
elif type==xlStockOHLC then
	let description=msg882
elif type==xlStockVHLC then
	let description=msg883
elif type==xlStockVOHLC then
	let description=msg884
elif type==xlSurface then
	let description=msg885
elif type==xlSurfaceTopView then
	let description=msg886
elif type==xlSurfaceTopViewWireframe then
	let description=msg887
elif type==xlSurfaceWireframe then
	let description=msg888
elif type==xlXYScatter then
	let description=msg889
elif type==xlXYScatterLines then
	let description=msg890
elif type==xlXYScatterLinesNoMarkers then
	let description=msg891
elif type==xlXYScatterSmooth then
	let description=msg892
elif type==xlXYScatterSmoothNoMarkers then
	let description=msg893
endIf
return description
EndFunction

Void Function describeChart (object Chart, string seriesDescription, string seriesUnit, string pointDescription, string pointDescriptionPlural, int sayPercentageContribution)
var
string CategoryAxisTitle,
string ValueAxisTitle,
string seriesLegend,
object CurrentSeries,
int seriesIndex,
int seriesCount,
int pointIndex,
int pointCount,
string CategoryReading,
string valueReading,
string percentCalc,
int roundedPercent, ; rounded value
string ValueRangeSourceSheet,
string NextValueReading, ; collect contiguous points with same valueReading
int NewSet, ; new set of contiguous points with same valueReading
string categoryRange,
string valueRange,
string categoryTitle,
string valueTitle

if chart.hasAxis(xlCategory) then
	let CategoryAxisTitle=chart.axes(xlCategory).axisTitle.caption
	if categoryAxisTitle=="" then
		let categoryAxisTitle=msg803a ; category
		say(msg803+msg803b, ot_string) ; category axis unlabeled
	else
		say(msg803+CategoryAxisTitle, ot_string)
	endIf
else
	let CategoryAxisTitle=msg803a ; category
endIf
if chart.hasAxis(xlValue) then
	let ValueAxisTitle=chart.axes(xlValue).axisTitle.caption
	if valueAxisTitle =="" then
		let valueAxisTitle=msg804a ; value
	say(msg804+msg804b, ot_string) ; is unlabeled
	else
		say(msg804+ValueAxisTitle, ot_string)
	endIf
else
	let valueAxisTitle=msg804a ; y
endIf
let seriesCount=chart.seriesCollection.count
let seriesIndex=1
if seriesDescription!="" then
say(msg805+intToString(seriesCount)+seriesDescription, ot_string) ; chart contains x lines, sets of bars etc.
else ; must be a pie chart
	let seriesCount=1
endIf
while seriesIndex <=seriesCount
	let currentSeries=chart.seriesCollection(seriesIndex)
	let categoryRange=StringSegment (currentSeries.formula, ",", 2)
	let valueRange=StringSegment (currentSeries.formula, ",", 3)
	let valueRangeSourceSheet=stringSegment(valueRange,"!",1)
	if valueRangeSourceSheet !="" then
		let valueRangeSourceSheet=valueRangeSourceSheet+msg766 ; sheetX!
	endIf
	let seriesLegend=currentSeries.name
	if seriesUnit !="" then
		say(seriesUnit+intToString(seriesIndex), ot_string) ; line, set of bars (etc) x
	endIf
	if seriesLegend!="" then
		say(msg807+seriesLegend, ot_string)
	endIf
	let pointCount=currentSeries.points.count
	if pointCount > 0 then
		say(msg808+intToString(pointCount)+pointDescriptionPlural, ot_string) ; has x points, bars etc
	endIf
	let newSet=true	let pointIndex=1
	while pointIndex <=pointCount
		let CategoryReading=oExcel.evaluate(categoryRange).cells(pointIndex).text
		let valueReading=oExcel.evaluate(valueRange).cells(pointIndex).text
		if sayPercentageContribution then			let PercentCalc=oExcel.evaluate(valueRange).cells(pointIndex).address
			let percentCalc=msg762+msg767+valueRangeSourceSheet+percentCalc+msg768+valueRange+msg769
			let roundedPercent=oExcel.evaluate(percentCalc)
		endIf
		if pointIndex < pointCount && not sayPercentageContribution then
			let NextValueReading=oExcel.evaluate(valueRange).cells(pointIndex+1).text
	else
		let newSet=true ; force last point to be announced.
	endIf
	if newSet || valueReading !=nextValueReading then ; ie first or last in set
			say(pointDescription+intToString(pointIndex), ot_string) ; point, bar (etc) x
			say(currentSeries.points(pointIndex).dataLabel.caption, ot_string)
			say(CategoryAxisTitle+"="+CategoryReading, ot_string)
		endIf
		; only want to read value axis title and value if next point is different
		; otherwise suppress until found end of same value readings
		if NextValueReading != valueReading || pointIndex==pointCount then
			say(ValueAxisTitle+"="+valueReading, ot_string)
			if SayPercentageContribution && not stringContains(currentSeries.points(pointIndex).dataLabel.caption, msg772) then
			say(msg770+intToString(roundedPercent)+msg771, ot_string)
			endIf
		let NewSet=true
		else ; same, ignore until found end of same values
			if newSet then ; announce "through" unless last point
			say(msg897, ot_string) ; through
			let newSet=false ; not a new set, continuing old set.
		endIf
		endIf
		let pointIndex=pointIndex+1
	endWhile
	let seriesIndex=seriesIndex+1
endWhile
EndFunction

Function ReadChart (object chart)
var
string ChartTitle,
string seriesDescription, ; lines, sets of bars, etc
string seriesUnit, ; line, set of bars, etc
string pointDescription, ; point, bar, etc
string pointDescriptionPlural, ; points, bars etc
int sayPercentageContribution, ; used for Pie charts and those for which the value contributes to a total.
int type
let type=chart.chartType
if type < 0 then
; negate
	let type=(type*-1)
endIf
say(msg800+getChartTypeDescription(chart), ot_string) ; chart description:
let chartTitle=chart.chartTitle.caption
if chartTitle=="" then
	let chartTitle=chart.name
endIf
say(msg802+chartTitle, ot_string)
if Type==xlLine ||
	Type==xlLineMarkers ||
	type==xlLineMarkersStacked ||
	type==xlLineMarkersStacked100 ||
	type==xlLineStacked ||
	type==xlLineStacked100 then
	let seriesDescription=msg806 ; lines
	let seriesUnit=msg806a ; line
	let pointDescription=msg810 ; point
	let pointDescriptionPlural=msg809 ; points
	let sayPercentageContribution=false
	describeChart(chart, seriesDescription, seriesUnit, pointDescription, pointDescriptionPlural, sayPercentageContribution)
elif Type==xlBarClustered ||
	type==xlBarStacked ||
	type==xlBarStacked100 ||
	type==xlConeBarClustered ||
	type==xlConeBarStacked ||
	type==xlConeBarStacked100 ||
	type==xlCylinderBarClustered ||
	type==xlCylinderBarStacked ||
	type==xlCylinderBarStacked100 ||
	type==xlPyramidBarClustered ||
	type==xlPyramidBarStacked ||
	type==xlPyramidBarStacked100 then
	let seriesDescription=msg811 ; distinct sets of horizontal bars
	let seriesUnit=msg812 ; set (of bars)
	let pointDescription=msg813 ; bar
	let pointDescriptionPlural=msg814 ; bars
	let sayPercentageContribution=false
	describeChart(chart, seriesDescription, seriesUnit, pointDescription, pointDescriptionPlural, sayPercentageContribution)
elif type==xlColumnClustered ||
	type==xlColumnStacked ||
	type==xlColumnStacked100 ||
	type==xlConeCol ||
	type==xlConeColClustered ||
	type==xlConeColStacked ||
	type==xlConeColStacked100 ||
	type==xlCylinderCol ||
	type==xlCylinderColClustered ||
	type==xlCylinderColStacked ||
	type==xlCylinderColStacked100 ||
	type==xlPyramidCol ||
	type==xlPyramidColStacked ||
	type==xlPyramidColStacked100 			then
	let seriesDescription=msg815 ; distinct sets of vertical columns
	let seriesUnit=msg812 ; set (of columns)
	let pointDescription=msg816 ; column
	let pointDescriptionPlural=msg817 ; columns
	let sayPercentageContribution=false
	describeChart(chart, seriesDescription, seriesUnit, pointDescription, pointDescriptionPlural, sayPercentageContribution)
elif type==xlPie ||
	type==xlPieExploded then
	let seriesDescription="" ; only one series for a pie chart
	let seriesUnit="" ; not applicable
	let pointDescription=msg819 ; segment
	let pointDescriptionPlural=msg820 ; segments
	let sayPercentageContribution=true
	describeChart(chart, seriesDescription, seriesUnit, pointDescription, pointDescriptionPlural, sayPercentageContribution)
elif type==xlDoughnut ||
	type==xlDoughnutExploded then
	let seriesDescription=msg820a ; distinct sets of slices
	let seriesUnit=msg812 ; set (of slices)
	let pointDescription=msg819 ; segment
	let pointDescriptionPlural=msg820 ; segments
	let sayPercentageContribution=true
	describeChart(chart, seriesDescription, seriesUnit, pointDescription, pointDescriptionPlural, sayPercentageContribution)
elif type > 0 then
	let seriesDescription=msg818 ; series
	let seriesUnit=msg818 ; series
	let pointDescription=msg810 ; point
	let pointDescriptionPlural=msg809 ; points
	let sayPercentageContribution=false
	describeChart(chart, seriesDescription, seriesUnit, pointDescription, pointDescriptionPlural, sayPercentageContribution)
else
	say(msg898, ot_string) ; no chart active
endIf
EndFunction

Function Unknown (string TheName, int IsScript)
say(msg131, ot_help) ; this feature is unavailable in this version of Excel.
EndFunction	


Script moveToWorksheet ()
var
object worksheets,
int index,
int count,
int choice,
string sheetList,
string sheetName

let worksheets=oExcel.activeWorkbook.worksheets 
let count=worksheets.count
if count ==0 then
	say(msg901,ot_message)
	return
endIf
let index=1
while index <=count
	let sheetName=worksheets(index).name
	let sheetList=sheetList+sheetName+msg761
	let index=index+1
endWhile
let sheetList=stringLeft(sheetList,stringLength(sheetList)-1)
let choice=DlgSelectItemInList (sheetList, msg904, false)
if choice then
	worksheets(choice).select
endIf
EndScript

script sayExcelVersion()
var
int ver
let ver=GetProgramVersion (GetAppFilePath ())
if ver==verExcel97 then
	say(msg909,ot_message) ; Excel 97
elif ver==verExcel2000 then
	say(msg910,ot_message) ; Excel 2000
endIf
endScript

Script CloseOfficeAssistant ()
var
handle hWnd,
object OfficeAssistant,
object menubar
; Excel 2000
let menubar=msoGetMenubarObject()
let officeAssistant=oExcel.assistant
;note if we could set object properties then it would be a simple matter to set the visible property of the assistant object 
;to false to hide the assistant.
if !officeAssistant.visible then
	say(msg471,ot_string)
	return
endIf
speechOff()
if Menubar.controls(mnuHelp).controls(mnuHelpHideAssistant) then
	{alt+h} ; help
	pause()
	{o} ; toggle Office Assistant to off.
	pause()
else
; no menu item to turn off the assistant, we'll try find it manually.
; This is only applicable to Excel 97.
	SaveCursor()
	JAWSCursor()
	let hWnd = FindTopLevelWindow ("MSOAssistant", "")
	if (hWnd && IsWindowVisible (hWnd)) then
		MoveToWindow(hWnd)
		RightMouseButton ()
		pause()
		{h}
		pause()
		RestoreCursor()
	endIf
	delay(10)
endIf
speechOn()
; Test to see if we closed it.
if officeAssistant.visible then
	say(msg474,ot_status)
else
	say(msg473,ot_status)
endIf
EndScript